package ai.passio.passiosdk.passiofood.token

import ai.passio.passiosdk.passiofood.data.model.PassioTokenBudget

internal object TokenUsageTracker {

    private val tokensUsed = mutableListOf<PassioTokenBudget>()
    var listener: TokenUsageListener? = null

    fun track(apiName: String, tokenUsage: Int, overallUsage: Long, budget: Long) {
        val data = PassioTokenBudget(apiName, tokenUsage, overallUsage, budget)
        listener?.onTokensUsed(data)
        tokensUsed.add(data)
    }
}

internal interface TokenUsageListener {
    fun onTokensUsed(usage: PassioTokenBudget)
}