package ai.passio.passiosdk.core.utils

import android.util.Log

private const val TAG = "PAS-"

internal object PassioLog {

    private var mode: Int = 0

    fun setupMode(mode: Int) {
        this.mode = mode
    }

    fun e(tag: String, message: String) {
        Log.e(TAG + tag, message)
    }

    fun w(tag: String, message: String) {
        Log.w(TAG + tag, message)
    }

    fun i(tag: String, message: String) {
        if (mode == 0) {
            return
        }

        Log.i(TAG + tag, message)
    }

    fun d(tag: String, message: String) {
        if (mode == 0 || mode == 1) {
            return
        }

        Log.d(TAG + tag, message)
    }

    fun v(tag: String, message: String) {
        if (mode == 0 || mode == 1) {
            return
        }

        Log.v(TAG + tag, message)
    }

    fun netI(tag: String, message: String) {
        if (mode != 666) {
            return
        }

        Log.i(TAG + tag, message)
    }

    fun netE(tag: String, message: String) {
        if (mode != 666) {
            return
        }

        Log.e(TAG + tag, message)
    }
}