package ai.passio.passiosdk.passiofood

import ai.passio.passiosdk.BuildConfig
import ai.passio.passiosdk.passiofood.advisor.AdvisorService
import ai.passio.passiosdk.passiofood.data.model.PassioAdvisorFoodInfo
import ai.passio.passiosdk.passiofood.data.model.PassioAdvisorResponse
import ai.passio.passiosdk.passiofood.data.model.PassioResult
import android.content.Context
import android.graphics.Bitmap
import androidx.annotation.Keep

@Keep
interface NutritionAdvisor {

    @Keep
    companion object {

        /**
         * Use this singleton to access the Passio SDK.
         */
        @JvmStatic
        val instance: NutritionAdvisor
            get() {
                if (PassioSDK.internalInstance == null) {
                    throw IllegalStateException("PassioSDK must be configured before accessing NutritionAdvisor")
                }
                return PassioSDK.internalInstance!!
            }
    }

    fun initConversation(callback: (result: PassioResult<Any>) -> Unit)

    fun sendMessage(
        message: String,
        callback: (response: PassioResult<PassioAdvisorResponse>) -> Unit
    )

    fun sendImage(
        bitmap: Bitmap,
        resolution: PassioImageResolution = PassioImageResolution.RES_512,
        callback: (response: PassioResult<PassioAdvisorResponse>) -> Unit
    )

    fun fetchIngredients(
        response: PassioAdvisorResponse,
        callback: (response: PassioResult<PassioAdvisorResponse>) -> Unit
    )

    fun setAdvisorProfile(
        profileJson: String,
        callback: (result: PassioResult<Any>) -> Unit
    )
}