package ai.passio.passiosdk.passiofood.advisor

import ai.passio.passiosdk.core.network.NetworkCallback

internal abstract class AdvisorNetworkCallback<T> : NetworkCallback<T> {

    override fun onFailure(code: Int, message: String) {
        if (code == 429) {
            onRateLimiting(message)
        } else {
            onAdvisorFailure(message)
        }
    }

    abstract fun onRateLimiting(message: String)

    abstract fun onAdvisorFailure(message: String)
}