package ai.passio.passiosdk.core.os

internal class NativeUtils private constructor() {

    companion object {
        val instance: NativeUtils by lazy { NativeUtils() }
    }

    private var baseUrl: String = "https://api.passiolife.com/v2/"
    private var devBaseUrl: String = "https://api-dev.passiolife.com/v2/"

    fun create(externalURL: String?) {
        if (!externalURL.isNullOrBlank()) {
            baseUrl = externalURL
            devBaseUrl = externalURL
        }
    }

    private fun url(dev: Boolean): String = if (dev) devBaseUrl else baseUrl

    fun getUPCUrl(dev: Boolean) = url(dev) + "products/food/productCode/"

    fun getUsageURL(dev: Boolean) = url(dev) + "licenses/usage/events"

    fun getLicenseURL(dev: Boolean): String =
        if (dev) "https://storage.googleapis.com/passiosdk-dev/license-keys-2/"
        else "https://storage.googleapis.com/passiosdk/license-keys-2/"

    fun getTokenURL(dev: Boolean) = url(dev) + "token-cache/nsdk/oauth/token/"

    fun getModelURL(): String = "https://storage.googleapis.com/passiosdk/android_models_2/"

    fun getTagsURL(dev: Boolean) = url(dev) + "products/food/"

    fun getPassioKeys(key: String): Array<String> {
        val hex = key.encodeToByteArray().joinToString("") {
            it.toUByte().toString(16).padStart(2, '0').uppercase()
        }
        val reversed = hex + hex.reversed()
        val kStr = reversed.substring(2, 34)
        val iStr = reversed.substring(65, 81)
        return arrayOf(kStr, iStr)
    }

    fun getSearchURL(dev: Boolean) = url(dev) + "products/food/search/advanced"

    fun getSemanticSearchURL(dev: Boolean) = url(dev) + "products/food/search/semantic"

    fun getFoodFetchURL(dev: Boolean) = url(dev) + "products/food/search/result/"

    fun getRefCodeURL(dev: Boolean) = url(dev) + "products/food/search/result/refCode/"

    fun getMetadataURL(dev: Boolean) = url(dev) + "products/sdk/metadata/for/"

    fun getScanURL(dev: Boolean) = url(dev) + "products/food/scan/defaults"

    fun getMealPlanURL(dev: Boolean) = url(dev) + "products/food/recommend/mealPlans"

    fun getSuggestionURL(dev: Boolean) = url(dev) + "products/food/suggest/mealTimes/"

    fun getNextIngredientPredictionURL(dev: Boolean) = url(dev) + "products/sdk/tools/predictIngredients"

    fun getKey1(): String = "EDC3ED782D88D9FC99879B5583E427E8"

    fun getKey2(): String = "2FECA684FE8B1A4E"

    fun getAdvisorTokenUrl(dev: Boolean) = url(dev) + "token-cache/nutrition-advisor/oauth/token/"

    fun getAdvisorBaseUrl(dev: Boolean) = url(dev) + "products/nutrition-advisor/"

    fun getAdvisorToolsUrl(dev: Boolean) = url(dev) + "products/sdk/tools/"

    fun getIconUrl(): String = "https://cdn.passiolife.com/label-icons/"

    fun getLocalDatasetId(): String = "4c0b8b68-943a-11ee-bdd6-7e580758e426"

    fun getTokenUrl(dev: Boolean): String = url(dev) + "token-cache/unified/oauth/token/"
}