package ai.passio.passiosdk.passiofood.config

import ai.passio.passiosdk.core.config.SDKFileConfig
import ai.passio.passiosdk.core.config.SDKFileType

internal object passio_metadata : SDKFileType {
    override val name: String
        get() = "passio_metadata"
}

internal object passio_dataset : SDKFileType {
    override val name: String
        get() = "passio_dataset"
}

internal class PassioSDKFileConfig : SDKFileConfig() {

    override fun nameToSDKFileType(name: String): SDKFileType {
        return when (name) {
            passio_metadata.name -> passio_metadata
            passio_dataset.name -> passio_dataset

            else -> throw IllegalArgumentException("No known string for PassioModel: $this")
        }
    }
}
