package ai.passio.passiosdk.passiofood.file

import ai.passio.passiosdk.core.config.SDKFileType
import ai.passio.passiosdk.core.file.PassioFileManager
import ai.passio.passiosdk.core.utils.FileUtil
import ai.passio.passiosdk.passiofood.PassioSDKImpl
import ai.passio.passiosdk.passiofood.config.PassioSDKFileConfig
import ai.passio.passiosdk.passiofood.config.passio_dataset
import android.content.Context
import android.util.Log
import java.io.File

internal class PassioFoodFileManager(
    sdkFileConfig: PassioSDKFileConfig
) : PassioFileManager(sdkFileConfig) {

    override fun getAvailableFileTypes(): List<SDKFileType> {
        val availableTypes = mutableListOf<SDKFileType>()

        availableTypes.add(passio_dataset)

        return availableTypes
    }

    override fun printVersions(context: Context) {
        val availableTypes = getAvailableFileTypes()
        val installedVersion = getInstalledVersion(context)
        Log.i(PassioFileManager::class.java.simpleName, "Installed: $installedVersion")

        val shippedFiles = getFilesFromAssets(context, availableTypes)
        val shippedVersion = if (shippedFiles.isNotEmpty()) {
            shippedFiles.first().split(File.pathSeparator).last().split(".")[1].toInt()
        } else {
            0
        }
        Log.i(PassioFileManager::class.java.simpleName, "Shipped: $shippedVersion")
    }

    fun getFilesMissingFromFolder(
        context: Context,
        parent: String,
        requiredFiles: List<SDKFileType>,
        compressed: Boolean = false
    ): List<String> {
        val missingFiles = mutableListOf<String>()
        if (compressed) {
            missingFiles.addAll(requiredFiles.map { "${it.name}.${PassioSDKImpl.FILE_VERSION}.passiosecure2" })
        } else {
            missingFiles.addAll(requiredFiles.map { "${it.name}.${PassioSDKImpl.FILE_VERSION}.passiosecure" })
        }

        val root = File(
            context.cacheDir.absolutePath + File.separator +
                    CACHE_ROOT + File.separator +
                    CACHE_NUTRITION_FOLDER + File.separator +
                    parent
        )
        if (!root.exists() && !root.isDirectory) {
            return missingFiles
        }

        root.listFiles()?.forEach { file ->
            requiredFiles.forEach { sdkFileType ->
                if (file.name.startsWith(sdkFileType.name)) {
                    missingFiles.remove(file.name)
                }
            }
        }

        return missingFiles
    }
}