package ai.passio.passiosdk.passiofood.mlkit

import com.google.mlkit.vision.barcode.BarcodeScanner
import com.google.mlkit.vision.common.InputImage

internal class BarcodeScannerProxy17(barcodeScannerObject: Any) : PassioBarcodeScanner {

    private val barcodeScanner: BarcodeScanner = barcodeScannerObject as BarcodeScanner

    override fun process(
        inputImage: InputImage,
        onSuccess: (result: List<BarcodeProxy>) -> Unit,
        onFailure: (exception: Exception) -> Unit
    ) {
        barcodeScanner.process(inputImage)
            .addOnSuccessListener { barcodes ->
                onSuccess(barcodes.map { BarcodeProxy(it) })
            }
            .addOnFailureListener(onFailure)
    }
}