package ai.passio.passiosdk.core.icons

import ai.passio.passiosdk.BuildConfig
import ai.passio.passiosdk.core.file.PassioFileManager
import ai.passio.passiosdk.core.utils.FileUtil
import android.content.Context
import android.graphics.Bitmap
import java.io.File

private const val ICON_ROOT_FOLDER = "icons"

internal object IconFileManager {

    fun storeIcon(
        context: Context,
        passioID: String,
        bitmap: Bitmap,
        size: IconSize
    ): Boolean {
        val root =
            PassioFileManager.CACHE_ROOT + File.separator +
                    PassioFileManager.CACHE_NUTRITION_FOLDER + File.separator +
                    ICON_ROOT_FOLDER + File.separator +
                    size.name.lowercase()

        return FileUtil.writeBitmapToCache(context, "$passioID.jpg", root, bitmap) != null
    }

    fun loadIcon(
        context: Context,
        passioID: String,
        size: IconSize
    ): Bitmap? {
        val root = PassioFileManager.CACHE_ROOT + File.separator +
                PassioFileManager.CACHE_NUTRITION_FOLDER + File.separator +
                ICON_ROOT_FOLDER + File.separator +
                size.name.lowercase()

        return FileUtil.loadBitmapFromCache(context, "$passioID.jpg", root)
    }
}