package ai.passio.passiosdk.core.network

import java.io.ByteArrayOutputStream
import java.io.IOException
import java.net.URL
import javax.net.ssl.HttpsURLConnection

internal class NetworkBinaryTask(
    private val urlString: String,
    private val metadata: String? = null
) : NetworkTask<ByteArray>() {

    override fun executeTask(): ByteArray {
        val url = URL(urlString)
        var connection: HttpsURLConnection? = null
        return try {
            connection = (url.openConnection() as? HttpsURLConnection)
            connection?.run {
                // Timeout for reading InputStream arbitrarily set to 3000ms.
                readTimeout = 1500
                // Timeout for connection.connect() arbitrarily set to 3000ms.
                connectTimeout = 1500
                // For this use case, set HTTP method to GET.
                requestMethod = "GET"
                // Already true by default but setting just in case; needs to be true since this request
                // is carrying an input (response) body.
                doInput = true
                // User-agent header
                if (metadata != null) {
                    setRequestProperty("User-Agent", metadata)
                }
                if (enableLog) {
                    logRequest(this)
                }
                // Open communications link (network traffic occurs here).
                connect()
                if (enableLog) {
                    logResponse(this)
                }
                //publishProgress(CONNECT_SUCCESS)
                checkResponse(this)
                // Retrieve the response body as an InputStream.
                //publishProgress(GET_INPUT_STREAM_SUCCESS, 0)
                inputStream?.let { stream ->
                    // Converts Stream to String with max length of 500.
                    val buffer = ByteArrayOutputStream()
                    var nRead: Int = 0
                    val block = ByteArray(1024)
                    while ({ nRead = stream.read(block, 0, block.size); nRead }() != -1) {
                        buffer.write(block, 0, nRead)
                    }
                    buffer.toByteArray()
                }
            } ?: throw IOException("Could not open http connection")
        } finally {
            // Close Stream and disconnect HTTPS connection.
            connection?.inputStream?.close()
            connection?.disconnect()
        }
    }
}