package ai.passio.passiosdk.core.os

import java.util.concurrent.ThreadFactory
import java.util.concurrent.atomic.AtomicLong

internal class PassioThreadFactory : ThreadFactory {

    val count = AtomicLong(0)

    override fun newThread(r: Runnable?): Thread {
        val thread = Thread(r, "passio-${count.getAndIncrement()}")
        thread.priority = Thread.MAX_PRIORITY
        return thread
    }
}