package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.Barcode
import ai.passio.passiosdk.passiofood.upc.ResponseIngredient

data class PassioFoodMetadata(
    var foodOrigins: List<PassioFoodOrigin>? = null,
    var barcode: Barcode? = null,
    var ingredientsDescription: String? = null,
    var tags: List<String>? = null
) {
    internal companion object {
        fun fromResponse(result: ResponseIngredient?): PassioFoodMetadata {
            val metadata = PassioFoodMetadata()

            if (result == null) {
                return metadata
            }

            if (result.origin != null) {
                val originsTemp = mutableListOf<PassioFoodOrigin>()
                result.origin!!.forEach {
                    originsTemp.add(PassioFoodOrigin(it.id, it.source, result.licenseCopy))
                }
                metadata.foodOrigins = originsTemp
            }

            metadata.barcode = result.branded.productCode
            metadata.ingredientsDescription = result.branded.ingredients
            metadata.tags = result.tags

            return metadata
        }
    }

    fun openFoodLicense(): String? {
        return foodOrigins?.find { it.source == "openfood" }?.licenseCopy
    }
}