package ai.passio.passiosdk.passiofood.data.model.internal

import ai.passio.passiosdk.passiofood.PassioID
import ai.passio.passiosdk.passiofood.data.NO_LABEL
import ai.passio.passiosdk.passiofood.data.model.IconDefaults

internal data class FoodItemsResult(
    val passioID: PassioID,
    val displayName: String,
    val filenameIcon: String = IconDefaults.passioFoodItemIcon.iconName,
    val nutritionID: String = "",
    val defaultNumber: Double = 1.0,
    val defaultUnit: String?,
    val defaultSize: String?
) {

    val defaultAmountLabel: String by lazy {
        if (defaultSize != null && defaultUnit != null) {
            "$defaultSize $defaultUnit"
        } else defaultSize ?: (defaultUnit ?: NO_LABEL)
    }
}