package ai.passio.passiosdk.passiofood.fragment

import ai.passio.passiosdk.core.camera.PassioCameraViewProvider
import ai.passio.passiosdk.passiofood.PassioSDK
import android.Manifest
import android.content.pm.PackageManager
import androidx.camera.core.CameraSelector
import androidx.camera.view.PreviewView
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import androidx.lifecycle.LifecycleOwner

private val REQUIRED_PERMISSIONS = arrayOf(Manifest.permission.CAMERA)
private const val REQUEST_CODE_PERMISSIONS = 581

abstract class PassioCameraFragment(
    private val tapToFocus: Boolean = false,
    private val useFrontCamera: Boolean = false,
) : Fragment(),
    PassioCameraViewProvider {

    override fun requestPreviewView(): PreviewView = getPreviewView()

    override fun requestCameraLifecycleOwner(): LifecycleOwner = this

    override fun onResume() {
        super.onResume()
        if (!hasPermissions()) {
            requestPermissions(REQUIRED_PERMISSIONS, REQUEST_CODE_PERMISSIONS)
            return
        } else {
            onCameraPermissionGranted()
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        PassioSDK.instance.stopCamera()
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        if (requestCode == REQUEST_CODE_PERMISSIONS) {
            if (allPermissionsGranted()) {
                onCameraPermissionGranted()
            } else {
                onCameraPermissionDenied()
            }
        }
    }

    protected fun hasPermissions() = REQUIRED_PERMISSIONS.all {
        ContextCompat.checkSelfPermission(requireContext(), it) == PackageManager.PERMISSION_GRANTED
    }

    private fun allPermissionsGranted() = REQUIRED_PERMISSIONS.all {
        ContextCompat.checkSelfPermission(requireContext(), it) == PackageManager.PERMISSION_GRANTED
    }

    private fun onCameraPermissionGranted() {
        startPassioCamera()
        onCameraReady()
    }

    open fun startPassioCamera() {
        val cameraFacing = if (!useFrontCamera) {
            CameraSelector.LENS_FACING_BACK
        } else {
            CameraSelector.LENS_FACING_FRONT
        }
        PassioSDK.instance.startCamera(
            this,
            0,
            cameraFacing,
            tapToFocus
        ) {
            println(it)
        }
    }


    abstract fun getPreviewView(): PreviewView

    abstract fun onCameraReady()

    abstract fun onCameraPermissionDenied()
}