package ai.passio.passiosdk.core.migz;

/**
 * Represents an {@link InterruptedException} that has been caught and rethrown as a runtime (unchecked) exception.
 *
 * @author Jeff Pasternack
 */
class UncheckedInterruptedException extends RuntimeException {
    /**
     * Creates a new instance, wrapped the provided {@link InterruptedException}
     *
     * @param e the {@link InterruptedException} being wrapped
     */
    public UncheckedInterruptedException(InterruptedException e) {
        super(e);
    }

    @Override
    public InterruptedException getCause() {
        return (InterruptedException) super.getCause();
    }
}
