package ai.passio.passiosdk.passiofood.search

import ai.passio.passiosdk.core.utils.asStringList
import ai.passio.passiosdk.core.utils.getJSONArrayOptional
import ai.passio.passiosdk.core.utils.getListOptional
import ai.passio.passiosdk.core.utils.getObjectOptional
import ai.passio.passiosdk.core.utils.getStringOptional
import ai.passio.passiosdk.passiofood.data.network.TokenResponse
import ai.passio.passiosdk.passiofood.upc.ResponsePortions
import org.json.JSONObject

internal class SearchResponse(json: String): TokenResponse(json) {
    val results: List<SearchResult> by lazy {
        val list = mutableListOf<SearchResult>()
        val jArray = getJSONArray("results")
        for (i in 0 until jArray.length()) {
            list.add(SearchResult(jArray.getJSONObject(i).toString()))
        }
        list
    }
    val alternateNames: List<String> by lazy {
        getJSONArrayOptional("alternateNames")?.asStringList() ?: emptyList()
    }
}

internal open class SearchResult(json: String): JSONObject(json) {
    val refCode: String by lazy { this.getStringOptional("refCode") ?: "" }
    val type: String by lazy { getString("type") }
    val displayName: String by lazy { getString("displayName") }
    val stemmedDisplayName: String by lazy { getString("stemmedDisplayName") }
    val shortName: String by lazy { getString("shortName") }
    val score: Double by lazy { getDouble("score") }
    val brandName: String by lazy { getString("brandName") }
    val iconId: String by lazy { getString("iconId") }
    val labelId: String by lazy { getString("labelId") }
    val synonymId: String by lazy { getString("synonymId") }
    val scoredName: String by lazy { getString("scoredName") }
    val recipeId: String by lazy { getString("recipeId") }
    val referenceId: String by lazy { getString("referenceId") }
    val resultId: String by lazy { getString("resultId") }
    val nutritionPreview: NutritionPreviewResult by lazy {
        NutritionPreviewResult(getJSONObject("nutritionPreview").toString())
    }
    val tags: List<String>? by lazy {
        getJSONArrayOptional("tags")?.asStringList()
    }
}

internal class NutritionPreviewResult(json: String): JSONObject(json) {
    val portion: ResponsePortions by lazy {
        getObjectOptional(this, "portion", ::ResponsePortions)!!
    }
    val calories: Double by lazy { getDouble("calories") }
    val carbs: Double by lazy { getDouble("carbs") }
    val protein: Double by lazy { getDouble("protein") }
    val fat: Double by lazy { getDouble("fat") }
    val fiber: Double by lazy { getDouble("fiber") }
}