package ai.passio.passiosdk.core.sharedpreferences

import android.content.Context

internal class ReportPreferencesManager(context: Context) : CorePreferencesManager(context) {

    companion object Key {
        private const val PREF_LAST_REPORTED = "lastReported"
    }

    fun getLastReported(eventName: String): Long {
        return sharedPreferences.getLong("$PREF_LAST_REPORTED~$eventName", 0L)
    }

    fun setLastReported(eventName: String, time: Long) {
        sharedPreferences.edit().putLong("$PREF_LAST_REPORTED~$eventName", time).apply()
    }
}