package ai.passio.passiosdk.passiofood.mlkit

import com.google.mlkit.vision.text.TextRecognizer

internal object TextRecognitionFactory {

    fun getTextRecognizer(): TextRecognizer {
        return try { try17() }
            catch (e: ClassNotFoundException) {
                try { try16() }
                catch (e: Exception) { throw e }
        }
    }

    private fun try17(): TextRecognizer {
        val optionsClazz =
            Class.forName("com.google.mlkit.vision.text.latin.TextRecognizerOptions")
        val optionsInstance = optionsClazz.getField("DEFAULT_OPTIONS").get(null)

        val interfaceClazz =
            Class.forName("com.google.mlkit.vision.text.TextRecognizerOptionsInterface")

        val recognitionClazz = Class.forName("com.google.mlkit.vision.text.TextRecognition")
        val recognitionMethod = recognitionClazz.getMethod("getClient", interfaceClazz)
        return recognitionMethod.invoke(null, optionsInstance) as TextRecognizer
    }

    private fun try16(): TextRecognizer {
        val recognitionClazz = Class.forName("com.google.mlkit.vision.text.TextRecognition")
        val recognitionMethod = recognitionClazz.getMethod("getClient")
        return recognitionMethod.invoke(null) as TextRecognizer
    }
}