package ai.passio.passiosdk.passiofood.voice.remote

import ai.passio.passiosdk.core.utils.getList
import ai.passio.passiosdk.passiofood.search.SearchResponse
import ai.passio.passiosdk.passiofood.search.SearchResult
import org.json.JSONObject

internal class ResponseVoice(json: String) : JSONObject(json) {
    val action: String by lazy { getString("action") }
    val mealTime: String by lazy { getString("mealTime") }
    val date: String by lazy { getString("date") }
    val items: List<ResponseVoiceItem> by lazy {
        getList(this, "items", ::ResponseVoiceItem)
    }
}

internal class ResponseVoiceItem(json: String) : SearchResult(json) {
    val ingredientName: String by lazy { getString("ingredientName") }
    val portionSize: String by lazy { getString("portionSize") }
    val weightGrams: Double by lazy { getDouble("weightGrams") }
}