package ai.passio.passiosdk.core.network

import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader
import java.net.URL
import javax.net.ssl.HttpsURLConnection

internal class NetworkStringTask(
    urlString: String,
    headers: Map<String, String> = mapOf(),
) : NetworkTask<String>(urlString, headers) {

    override fun executeTask(): String {
        val url = URL(url)
        var connection: HttpsURLConnection? = null
        return try {
            connection = (url.openConnection() as? HttpsURLConnection)
            connection?.run {
                // Timeout for reading InputStream arbitrarily set to 3000ms.
                readTimeout = 6000
                // Timeout for connection.connect() arbitrarily set to 3000ms.
                connectTimeout = 6000
                // For this use case, set HTTP method to GET.
                requestMethod = "GET"
                headers.forEach { (k, v) ->
                    setRequestProperty(k, v)
                }
                if (enableLog) {
                    logRequest(this)
                }
                // Already true by default but setting just in case; needs to be true since this request
                // is carrying an input (response) body.
                doInput = true
                // Open communications link (network traffic occurs here).
                connect()
                //publishProgress(CONNECT_SUCCESS)
                if (enableLog) {
                    logResponse(this)
                }
                if (trackTokens) {
                    trackTokens(connection)
                }
                checkResponse(connection)
                // Retrieve the response body as an InputStream.
                //publishProgress(GET_INPUT_STREAM_SUCCESS, 0)

                val streamReader = InputStreamReader(inputStream)
                val reader = BufferedReader(streamReader)
                val stringBuilder = StringBuilder()

                var inputLine: String? = null
                while ({ inputLine = reader.readLine(); inputLine }() != null) {
                    stringBuilder.append(inputLine)
                }

                reader.close()
                streamReader.close()

                stringBuilder.toString()
            } ?: throw IOException("Could not open http connection")
        } finally {
             try {
                 connection?.inputStream?.close()
                 connection?.errorStream?.close()
                 connection?.disconnect()
             } catch (e: Exception) { /* NO-OP */ }
        }
    }
}