package ai.passio.passiosdk.core.utils

import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject

internal fun <T : JSONObject> getListOptional(
    parent: JSONObject,
    key: String,
    factory: (json: String) -> T
): List<T>? {
    return try {
        val list = mutableListOf<T>()
        val jArray = parent.getJSONArray(key)
        for (i in 0 until jArray.length()) {
            list.add(factory(jArray.getJSONObject(i).toString()))
        }
        list
    } catch (e: JSONException) {
        null
    }
}

internal fun <T : JSONObject> getList(
    parent: JSONObject,
    key: String,
    factory: (json: String) -> T
): List<T> {
    return try {
        val list = mutableListOf<T>()
        val jArray = parent.getJSONArray(key)
        for (i in 0 until jArray.length()) {
            list.add(factory(jArray.getJSONObject(i).toString()))
        }
        list
    } catch (e: JSONException) {
        emptyList()
    }
}

internal fun JSONObject.getBooleanOptional(name: String): Boolean? {
    return try {
        this.getBoolean(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun <T : JSONObject> getObjectOptional(
    parent: JSONObject,
    key: String,
    factory: (json: String) -> T
): T? {
    val json = parent.getStringOptional(key) ?: return null

    return factory(json)
}

internal fun JSONObject.getStringOptional(name: String): String? {
    return try {
        this.getString(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun JSONObject.getDoubleOptional(name: String): Double? {
    return try {
        this.getDouble(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun JSONObject.getIntOptional(name: String): Int? {
    return try {
        this.getInt(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun JSONObject.getLongOptional(name: String): Long? {
    return try {
        this.getLong(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun JSONObject.getJSONArrayOptional(name: String): JSONArray? {
    return try {
        this.getJSONArray(name)
    } catch (e: JSONException) {
        null
    }
}

internal fun JSONArray.asStringList() : List<String> {
    val returnList = mutableListOf<String>()
    for (i in 0 until this.length()) {
        returnList.add(this.getString(i))
    }
    return returnList
}

internal fun JSONArray.asIntList() : List<Int> {
    val returnList = mutableListOf<Int>()
    for (i in 0 until this.length()) {
        returnList.add(this.getInt(i))
    }
    return returnList
}

