package ai.passio.passiosdk.core.utils

import android.app.ActivityManager
import android.content.Context

internal object MemoryUtil {

    fun printMemoryInfo(context: Context) {
        val memoryInfo = ActivityManager.MemoryInfo()
        val activityManager = context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager?
        activityManager!!.getMemoryInfo(memoryInfo)
        val runtime = Runtime.getRuntime()
        runtime.gc()
        val aval = getAvailableRuntimeMemory()
        PassioLog.i(MemoryUtil::class.java.simpleName, "Custom Memory = ${aval.toMB()}")

        PassioLog.i(MemoryUtil::class.java.simpleName, "Available Memory = ${memoryInfo.availMem.toMB()}")
        PassioLog.i(MemoryUtil::class.java.simpleName, "Total Memory = ${memoryInfo.totalMem.toMB()}")
        PassioLog.i(MemoryUtil::class.java.simpleName, "Runtime Max Memory = ${runtime.maxMemory().toMB()}")
        PassioLog.i(MemoryUtil::class.java.simpleName, "Runtime Total Memory = ${runtime.totalMemory().toMB()}")
        PassioLog.i(MemoryUtil::class.java.simpleName, "Runtime Free Memory = ${runtime.freeMemory().toMB()}")
        PassioLog.i(MemoryUtil::class.java.simpleName, "Is low = ${memoryInfo.lowMemory}")
    }

    fun getAvailableMemory(context: Context): Long {
        val memoryInfo = ActivityManager.MemoryInfo()
        val activityManager =
            context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager? ?: return 0L
        activityManager.getMemoryInfo(memoryInfo)
        return memoryInfo.availMem
    }

    fun getAvailableRuntimeMemory(): Long {
        val runtime = Runtime.getRuntime()
        runtime.gc()
        return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory()
    }

    private fun Long.toMB() = this / 1024 / 1024
}