package ai.passio.passiosdk.passiofood.data

import ai.passio.passiosdk.passiofood.data.model.PassioFoodAmount
import ai.passio.passiosdk.passiofood.data.model.PassioFoodItem
import ai.passio.passiosdk.passiofood.data.model.PassioIngredient
import ai.passio.passiosdk.passiofood.data.model.PassioRecognitionItem
import android.util.Base64
import org.json.JSONObject
import java.nio.charset.Charset

internal object DataUtils {

    private const val SHORT_NAME = "shortName"

    fun encodeMetadata(shortName: Boolean): String {
        val metadata = """{"$SHORT_NAME": $shortName}"""
        return Base64.encodeToString(metadata.toByteArray(), Base64.NO_WRAP)
    }

    fun metadataHasShortName(encoded: String): Boolean {
        val decoded = Base64.decode(encoded, Base64.DEFAULT).toString(Charset.defaultCharset())
        val jsonObject = JSONObject(decoded).optJSONObject("metadata")
        return jsonObject?.optBoolean(SHORT_NAME) ?: false
    }

    fun mapItemsByComponents(components: List<Pair<PassioFoodItem, String?>>): List<PassioFoodItem> {
        val returnList = mutableListOf<PassioFoodItem>()
        val occurrence = mutableMapOf<String, Int>()
        components.forEach { comp ->
            if (comp.second == null) {
                returnList.add(comp.first)
                return@forEach
            }

            if (occurrence.containsKey(comp.second)) {
                occurrence[comp.second!!] = occurrence[comp.second]!! + 1
            } else {
                occurrence[comp.second!!] = 1
            }
        }

        occurrence.forEach { (comp, occurred) ->
            if (occurred == 1) {
                val item = components.first { it.second == comp }.first
                returnList.add(item)
                return@forEach
            }

            val items = components.filter { it.second == comp }.map { it.first }

            val ingredientsWeight =
                items.map { it.ingredientWeight() }.reduce { acc, unitMass -> acc + unitMass }
                    .gramsValue()
            val amount = PassioFoodAmount.fromResponse(
                emptyList(),
                ingredientsWeight
            )
            val ingredients = items.map {
                PassioIngredient(
                    it.id,
                    it.refCode,
                    it.name,
                    it.iconId,
                    it.amount,
                    it.nutrientsReference(),
                    it.ingredients.first().metadata
                )
            }

            val recipe = PassioFoodItem(
                "",
                "",
                comp,
                "",
                "",
                amount,
                ingredients
            )
            returnList.add(recipe)
        }

        return returnList
    }
}