package ai.passio.passiosdk.passiofood.data.model.internal

import ai.passio.passiosdk.passiofood.data.model.PassioServingUnit

internal object ServingUnitHelper {

    fun getConversionUnits(currentUnits: List<PassioServingUnit>): List<PassioServingUnit> {
        val addedUnits = mutableMapOf<String, PassioServingUnit>()
        val teaspoonLabels = listOf("tsp", "teaspoon")
        val tablespoonLabels = listOf("tbsp", "tablespoon")
        val cupLabels = listOf("cup")

        currentUnits.forEach { unit ->
            when (unit.unitName) {
                "cup" -> {
                    if (currentUnits.find { it.unitName in teaspoonLabels } == null) {
                        addedUnits["tsp"] = PassioServingUnit("tsp", unit.weight * (1.0/48.0))
                    }
                    if (currentUnits.find { it.unitName in tablespoonLabels } == null) {
                        addedUnits["tbsp"] = PassioServingUnit("tbsp", unit.weight * (1.0/16.0))
                    }
                }
                "tbsp", "tablespoon" -> {
                    if (currentUnits.find { it.unitName in cupLabels } == null) {
                        addedUnits["cup"] = PassioServingUnit("cup", unit.weight * 16.0)
                    }
                    if (currentUnits.find { it.unitName in teaspoonLabels } == null) {
                        addedUnits["tsp"] = PassioServingUnit("tsp", unit.weight * (1.0/3.0))
                    }
                }
                "tsp", "teaspoon" -> {
                    if (currentUnits.find { it.unitName in cupLabels } == null) {
                        addedUnits["cup"] = PassioServingUnit("cup", unit.weight * 48.0)
                    }
                    if (currentUnits.find { it.unitName in tablespoonLabels } == null) {
                        addedUnits["tbsp"] = PassioServingUnit("tbsp", unit.weight * 3.0)
                    }
                }
            }
        }

        return addedUnits.keys.map { addedUnits[it]!! }
    }
}