package ai.passio.passiosdk.passiofood.mlkit

import android.graphics.Rect

internal class BarcodeProxy(barcodeObject: Any) {

    lateinit var value: String
    var boundingBox: Rect? = null

    init {
        try16(barcodeObject)
    }

    private fun try16(barcodeObject: Any) {
        val clazz = ReflectionCache.barcodeClass()
        val valueGetter = ReflectionCache.barcodeValue(clazz)
        val bbGetter = ReflectionCache.barcodeBoundingBox(clazz)
        val instance = clazz.cast(barcodeObject)
        value = valueGetter.invoke(instance) as String
        boundingBox = bbGetter.invoke(instance) as Rect?

    }
}