package ai.passio.passiosdk.passiofood.recognition

import ai.passio.passiosdk.core.config.SDKFileType
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN_ENv2
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_SSD_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_Yolo
import ai.passio.passiosdk.passiofood.file.PassioFoodFileManager
import ai.passio.passiosdk.passiofood.metadata.MetadataManager
import ai.passio.passiosdk.passiofood.tflite.TFLiteHNNKNNDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteObjectDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteYoloObjectDetector
import android.content.Context
import android.util.Size

internal class PassioExternalModelHolder(
    labelManager: MetadataManager,
    fileManager: PassioFoodFileManager
) : PassioModelHolder(labelManager, fileManager) {

    override fun initializeModel(
        context: Context,
        fileType: SDKFileType,
        version: Int
    ): Boolean {
        when (fileType) {
            passio_FoodNet_SSD_HNN -> {
                val modelName = "${passio_FoodNet_SSD_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val od2File = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_SSD_HNN
                )
                if (od2File == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val inputSize = Size(
                    PassioRecognizer.TF_OD_API_INPUT_SIZE,
                    PassioRecognizer.TF_OD_API_INPUT_SIZE
                )

                objectDetector = TFLiteObjectDetector(inputSize).apply {
                    createFromExternalModel(od2File)
                }

                return true
            }

            passio_FoodNet_HNN_ENv2 -> {
                val modelName = "${passio_FoodNet_HNN_ENv2.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val hnnFile = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_HNN_ENv2,
                    checkAlternatives = false
                )
                if (hnnFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = TFLiteHNNKNNDetector(false, inputSize, labels).apply {
                    createFromExternalModel(hnnFile)
                }

                return true
            }

            passio_FoodNet_HNN -> {
                val modelName = "${passio_FoodNet_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val hnnFile = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_HNN,
                    checkAlternatives = false
                )
                if (hnnFile == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = TFLiteHNNKNNDetector(true, inputSize, labels).apply {
                    createFromExternalModel(hnnFile)
                }

                return true
            }

            passio_FoodNet_Yolo -> {
                val modelName = "${passio_FoodNet_Yolo.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val od2File = fileManager.getStoredFile(
                    context,
                    passio_FoodNet_Yolo,
                    checkAlternatives = false
                )
                if (od2File == null) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "$modelName file doesn't exist"
                    )
                    return false
                }

                val inputSize = Size(
                    PassioRecognizer.TF_YOLO_INPUT_SIZE,
                    PassioRecognizer.TF_YOLO_INPUT_SIZE
                )

                objectDetector = TFLiteYoloObjectDetector(inputSize).apply {
                    createFromExternalModel(od2File)
                }

                return true
            }

            else -> throw  IllegalArgumentException("No known file type: ${fileType.name}")
        }
    }

    override fun getExtension(): String = "passio"
}