package ai.passio.passiosdk.passiofood.voting

import ai.passio.passiosdk.passiofood.ObjectDetectionCandidate
import kotlin.math.max
import kotlin.math.min

private const val MIN_INTERSECTION_RATIO = 0.65f

internal abstract class ObjectDetectionStrategy {

    fun process(candidates: List<ObjectDetectionCandidate>): List<ObjectDetectionCandidate> {
        // Candidates that should be removed because of the discardCandidate criteria
        val removedCandidates = mutableSetOf<ObjectDetectionCandidate>()
        for (i in 0 until candidates.size - 1) {
            val first = candidates[i].boundingBox
            val firstArea = first.width() * first.height()
            for (j in i + 1 until candidates.size) {
                val second = candidates[j].boundingBox
                val secondArea = second.width() * second.height()
                val intersectionArea = max(0f, min(first.right, second.right) - max(first.left, second.left)) *
                        max(0f, min(first.bottom, second.bottom) - max(first.top, second.top))
                if (firstArea >= secondArea) {
                    val ratio = intersectionArea / secondArea
                    if (ratio > MIN_INTERSECTION_RATIO) {
                        removedCandidates.add(discardCandidate(candidates[i], candidates[j]))
                    }
                } else {
                    val ratio = intersectionArea / firstArea
                    if (ratio > MIN_INTERSECTION_RATIO) {
                        removedCandidates.add(discardCandidate(candidates[i], candidates[j]))
                    }
                }
            }
        }
        return candidates.filter { !removedCandidates.contains(it) }
    }

    abstract fun discardCandidate(
        firstCandidate: ObjectDetectionCandidate,
        secondCandidate: ObjectDetectionCandidate
    ): ObjectDetectionCandidate
}