package ai.passio.passiosdk.core.authentication

import ai.passio.passiosdk.core.network.NetworkService
import ai.passio.passiosdk.core.network.SimpleNetworkCallback
import ai.passio.passiosdk.core.os.NativeUtils
import ai.passio.passiosdk.core.utils.PassioLog
import android.content.Context
import android.media.session.MediaSession.Token
import org.json.JSONObject

internal class LegacyTokenService(
    context: Context,
    licenseKey: String
) : TokenService(context, licenseKey) {

    override fun getUrl(dev: Boolean): String {
        return NativeUtils.instance.getTokenURL(dev) + licenseKey
    }

}