package ai.passio.passiosdk.core.network

import java.io.BufferedWriter
import java.io.IOException
import java.io.OutputStreamWriter
import java.net.URL
import javax.net.ssl.HttpsURLConnection

internal class PostNetworkTask(
    urlString: String,
    headers: Map<String, String> = mapOf("Content-Type" to "application/json"),
    private val payload: String? = null,
    private val readTimeout: Int = 3000,
    private val connectTimeout: Int = 3000,
) : NetworkTask<String>(urlString, headers) {

    override fun executeTask(): String {
        val url = URL(url)
        var connection: HttpsURLConnection? = null
        return try {
            connection = (url.openConnection() as? HttpsURLConnection)
            connection?.run {
                readTimeout = this@PostNetworkTask.readTimeout
                connectTimeout = this@PostNetworkTask.connectTimeout
                requestMethod = "POST"
                headers.forEach { (k, v) ->
                    setRequestProperty(k, v)
                }
                doInput = true
                doOutput = true

                if (enableLog) {
                    logRequest(this)
                    logBody(payload ?: "")
                }

                if (payload != null) {
                    val outputStream = connection.outputStream
                    val writer = BufferedWriter(OutputStreamWriter(outputStream))
                    writer.write(payload)
                    writer.flush()
                    writer.close()
                    outputStream.close()
                }
                // Open communications link (network traffic occurs here).
                connect()
                if (enableLog) {
                    logResponse(this)
                }
                if (trackTokens) {
                    trackTokens(this)
                }
                //publishProgress(CONNECT_SUCCESS)
                checkResponse(connection)
                // Retrieve the response body as an InputStream.
                //publishProgress(GET_INPUT_STREAM_SUCCESS, 0)

                getBody(inputStream)
            } ?: throw IOException("Could not open http connection")
        } finally {
            // Close Stream and disconnect HTTPS connection.
            try {
                connection?.outputStream?.close()
                connection?.inputStream?.close()
                connection?.disconnect()
            } catch (e: Exception) {
                // NO-OP
            }
        }
    }
}
