package ai.passio.passiosdk.core.utils

internal object DimenUtil {

    fun init3DFloatArray(
        dim1: Int,
        dim2: Int,
        dim3: Int,
        init: (Int, Int, Int) -> Float = { _, _, _ -> 0f }
    ): Array<Array<FloatArray>> {
        return Array(dim1) { i ->
            Array(dim2) { j ->
                FloatArray(dim3) { k ->
                    init(i, j, k)
                }
            }
        }
    }

    fun init2DFloatArray(
        dim1: Int, dim2: Int,
        init: (Int, Int) -> Float = { _, _ -> 0f }
    ): Array<FloatArray> {
        return Array(dim1) { i ->
            FloatArray(dim2) { j ->
                init(i, j)
            }
        }
    }

    fun init2DByteArray(
        dim1: Int, dim2: Int?,
        init: (Int, Int) -> Byte = { _, _ -> 0 }
    ): Array<ByteArray?> {
        return Array(dim1) { i ->
            if (dim2 == null) {
                null
            } else {
                ByteArray(dim2) { j ->
                    init(i, j)
                }
            }
        }
    }

    fun init2DIntArray(
        dim1: Int, dim2: Int,
        init: (Int, Int) -> Int = { _, _ -> 0 }
    ): Array<IntArray> {
        return Array(dim1) { i ->
            IntArray(dim2) { j ->
                init(i, j)
            }
        }
    }
}