package ai.passio.passiosdk.passiofood.advisor

import ai.passio.passiosdk.core.utils.getDoubleOptional
import ai.passio.passiosdk.core.utils.getIntOptional
import ai.passio.passiosdk.core.utils.getListOptional
import ai.passio.passiosdk.core.utils.getObjectOptional
import ai.passio.passiosdk.core.utils.getStringOptional
import ai.passio.passiosdk.passiofood.search.SearchResult
import org.json.JSONObject

internal class GenerateMealPlanResponse(json: String): JSONObject(json) {
    val constraints: MealPlanConstraints? by lazy {
        getObjectOptional(this, "constraints", ::MealPlanConstraints)
    }

    val shoppingList: List<MealPlanShoppingItem>? by lazy {
        getListOptional(this, "shoppingList", ::MealPlanShoppingItem)
    }

    val mealPlanDays: List<MealPlanDay>? by lazy {
        getListOptional(this, "mealPlanDays", ::MealPlanDay)
    }
}

internal class MealPlanConstraints(json: String): JSONObject(json) {
    val constraints: Map<String, Any> by lazy {
        val map = mutableMapOf<String, Any>()
        val root = getJSONObject("constraints")
        root.keys().forEach { key ->
            map[key] = root.get(key)
        }
        map
    }
    val macros: MealPlanMacros? by lazy { getObjectOptional(this, "macros", ::MealPlanMacros) }
}

internal class MealPlanShoppingItem(json: String): JSONObject(json) {
    val name: String? by lazy { getStringOptional("name") }
    val portionQuantity: Double? by lazy { getDoubleOptional("portionQuantity") }
    val portionSize: String? by lazy { getStringOptional("portionSize") }
}

internal class MealPlanDay(json: String): JSONObject(json) {
    val breakfast: MealPlanMeal? by lazy { getObjectOptional(this, "breakfast", ::MealPlanMeal) }
    val lunch: MealPlanMeal? by lazy { getObjectOptional(this, "lunch", ::MealPlanMeal) }
    val dinner: MealPlanMeal? by lazy { getObjectOptional(this, "dinner", ::MealPlanMeal) }
    val snack: MealPlanMeal? by lazy { getObjectOptional(this, "snack", ::MealPlanMeal) }
    val macros: MealPlanMacros? by lazy { getObjectOptional(this, "macros", ::MealPlanMacros) }
}

internal class MealPlanMeal(json: String) : JSONObject(json) {
    val recipes: List<MealPlanRecipe>? by lazy {
        getListOptional(this, "recipes", ::MealPlanRecipe)
    }
}

internal class MealPlanRecipe(json: String) : JSONObject(json) {
    val name: String? by lazy { getStringOptional("name") }
    val ingredients: List<SearchResult>? by lazy {
        getListOptional(this, "ingredients", ::SearchResult)
    }
    val preparation: String? by lazy { getStringOptional("preparation") }
    val macros: MealPlanMacros? by lazy { getObjectOptional(this, "macros", ::MealPlanMacros) }
}


internal class MealPlanMacros(json: String) : JSONObject(json) {
    val calories: Double? by lazy { getDoubleOptional("calories") }
    val protein: Double? by lazy { getDoubleOptional("protein") }
    val fiber: Double? by lazy { getDoubleOptional("fiber") }
    val carbs: Double? by lazy { getDoubleOptional("carbs") }
    val fat: Double? by lazy { getDoubleOptional("fat") }
    val sugar: Double? by lazy { getDoubleOptional("sugar") }
}