package ai.passio.passiosdk.passiofood.config

import ai.passio.passiosdk.core.config.SDKFileConfig
import ai.passio.passiosdk.core.config.SDKFileType

internal object passio_nutrition_HNN : SDKFileType {
    override val name: String
        get() = "passio_nutrition_HNN"
}

internal object passio_FoodNet_HNN : SDKFileType {
    override val name: String
        get() = "passio_FoodNet_HNN"
}

internal object passio_FoodNet_SSD_HNN : SDKFileType {
    override val name: String
        get() = "passio_FoodNet_SSD_HNN"
    override fun alternative(): SDKFileType {
        return passio_FoodNet_Yolo
    }
}

internal object passio_FoodNet_HNN_ENv2 : SDKFileType {
    override val name: String
        get() = "passio_FoodNet_HNN_ENv2"

    override fun alternative(): SDKFileType {
        return passio_FoodNet_HNN
    }
}

//internal object passio_search_vectorize : SDKFileType {
//    override val name: String
//        get() = "passio_search_vectorize"
//}

internal object passio_FoodNet_Yolo : SDKFileType {
    override val name: String
        get() = "passio_FoodNet_Yolo"

    override fun alternative(): SDKFileType {
        return passio_FoodNet_SSD_HNN
    }
}

internal object passio_metadata : SDKFileType {
    override val name: String
        get() = "passio_metadata"
}

internal object passio_dataset : SDKFileType {
    override val name: String
        get() = "passio_dataset"
}

internal class PassioSDKFileConfig : SDKFileConfig() {

    override fun nameToSDKFileType(name: String): SDKFileType {
        return when (name) {
            passio_nutrition_HNN.name -> passio_nutrition_HNN
            passio_FoodNet_SSD_HNN.name -> passio_FoodNet_SSD_HNN
            passio_FoodNet_HNN.name -> passio_FoodNet_HNN
            passio_FoodNet_HNN_ENv2.name -> passio_FoodNet_HNN_ENv2
            // passio_search_vectorize.name -> passio_search_vectorize
            passio_FoodNet_Yolo.name -> passio_FoodNet_Yolo
            passio_metadata.name -> passio_metadata
            passio_dataset.name -> passio_dataset

            else -> throw IllegalArgumentException("No known string for PassioModel: $this")
        }
    }
}
