package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.PassioFoodDataInfo
import ai.passio.passiosdk.passiofood.advisor.MealPlanMacros

data class PassioGeneratedMealPlan(
    val constraints: PassioGeneratedMealPlanConstraints?,
    val shoppingList: List<PassioGeneratedMealPlanShoppingItem>,
    val mealPlanDays: List<PassioGeneratedMealPlanDay>
)

data class PassioGeneratedMealPlanConstraints(
    val constraints: Map<String, Any>,
    val macros: PassioGeneratedMealPlanMacros
)

data class PassioGeneratedMealPlanShoppingItem(
    val name: String?,
    val portionQuantity: Double?,
    val portionSize: String?,
)

data class PassioGeneratedMealPlanDay(
    val breakfast: List<PassioGeneratedMealPlanRecipe>,
    val lunch: List<PassioGeneratedMealPlanRecipe>,
    val dinner: List<PassioGeneratedMealPlanRecipe>,
    val snack: List<PassioGeneratedMealPlanRecipe>,
    val macros: PassioGeneratedMealPlanMacros
)

data class PassioGeneratedMealPlanRecipe(
    val name: String?,
    val preparation: String?,
    val ingredients: List<PassioFoodDataInfo>,
    val macros: PassioGeneratedMealPlanMacros
)

data class PassioGeneratedMealPlanMacros(
    val calories: Double,
    val protein: Double,
    val fiber: Double,
    val carbs: Double,
    val fat: Double,
    val sugar: Double,
)