package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.PassioMealTime

data class PassioSpeechRecognitionModel(
    val action: PassioLogAction?,
    val mealTime: PassioMealTime?,
    val date: String,
    val advisorInfo: PassioAdvisorFoodInfo
)

enum class PassioLogAction {
    ADD,
    REMOVE,
    NONE
}

internal fun String.toLogAction(): PassioLogAction {
    return when (this.lowercase()) {
        "add" -> PassioLogAction.ADD
        "remove" -> PassioLogAction.REMOVE
        else -> PassioLogAction.NONE
    }
}

internal fun String.toMealTime(): PassioMealTime? {
    return when (this.lowercase()) {
        "breakfast" -> PassioMealTime.BREAKFAST
        "lunch" -> PassioMealTime.LUNCH
        "dinner" -> PassioMealTime.DINNER
        "snack" -> PassioMealTime.SNACK
        else -> null
    }
}