package ai.passio.passiosdk.core.os

internal class NativeUtils {

    companion object {
        val instance: NativeUtils by lazy { NativeUtils() }
    }

    private var nativePtr: Long = -1L

    fun create(externalURL: String?) {
        nativePtr = nativeInit(externalURL)
    }

    private external fun nativeInit(externalURL: String?): Long

    fun getUPCUrl(dev: Boolean): String {
        return nativeGetUPCUrl(dev, nativePtr)
    }

    private external fun nativeGetUPCUrl(dev: Boolean, nativePtr: Long): String

    fun getUsageURL(dev: Boolean): String {
        return nativeGetUsageURL(dev, nativePtr)
    }

    private external fun nativeGetUsageURL(dev: Boolean, nativePtr: Long): String

    fun getLicenseURL(dev: Boolean): String {
        return nativeGetLicenseURL(dev)
    }

    private external fun nativeGetLicenseURL(dev: Boolean): String

    fun getTokenURL(dev: Boolean): String {
        return nativeGetTokenURL(dev, nativePtr)
    }

    private external fun nativeGetTokenURL(dev: Boolean, nativePtr: Long): String

    fun getModelURL(): String {
        return nativeGetModelURL()
    }

    private external fun nativeGetModelURL(): String

    fun getTagsURL(dev: Boolean): String {
        return nativeGetTagsURL(dev, nativePtr)
    }

    private external fun nativeGetTagsURL(dev: Boolean, nativePtr: Long): String

    fun getPassioKeys(key: String): Array<String> {
        return nativeGetPassioKeys(key)
    }

    private external fun nativeGetPassioKeys(key: String): Array<String>

    fun getSearchURL(dev: Boolean): String {
        return nativeGetSearchURL(dev, nativePtr)
    }

    private external fun nativeGetSearchURL(dev: Boolean, nativePtr: Long): String

    fun getSemanticSearchURL(dev: Boolean): String {
        return nativeGetSemanticSearchURL(dev, nativePtr)
    }

    private external fun nativeGetSemanticSearchURL(dev: Boolean, nativePtr: Long): String

    fun getFoodFetchURL(dev: Boolean): String {
        return nativeGetFoodFetchURL(dev, nativePtr)
    }

    private external fun nativeGetFoodFetchURL(dev: Boolean, nativePtr: Long): String

    fun getRefCodeURL(dev: Boolean): String {
        return nativeGetRefCodeURL(dev, nativePtr)
    }

    private external fun nativeGetRefCodeURL(dev: Boolean, nativePtr: Long): String

    fun getMetadataURL(dev: Boolean): String {
        return nativeGetMetadataURL(dev, nativePtr)
    }

    private external fun nativeGetMetadataURL(dev: Boolean, nativePtr: Long): String

    fun getScanURL(dev: Boolean): String {
        return nativeGetScanURL(dev, nativePtr)
    }

    private external fun nativeGetScanURL(dev: Boolean, nativePtr: Long): String

    fun getMealPlanURL(dev: Boolean): String {
        return nativeGetMealPlanURL(dev, nativePtr)
    }

    private external fun nativeGetMealPlanURL(dev: Boolean, nativePtr: Long): String

    fun getSuggestionURL(dev: Boolean): String {
        return nativeGetSuggestionURL(dev, nativePtr)
    }

    private external fun nativeGetSuggestionURL(dev: Boolean, nativePtr: Long): String

    fun getNextIngredientPredictionURL(dev: Boolean): String {
        return nativeGetNextIngredientPredictionURL(dev, nativePtr)
    }

    private external fun nativeGetNextIngredientPredictionURL(dev: Boolean, nativePtr: Long): String

    fun getKey1(): String {
        return nativeGetKey1()
    }

    private external fun nativeGetKey1(): String

    fun getKey2(): String {
        return nativeGetKey2()
    }

    private external fun nativeGetKey2(): String

    fun getAdvisorTokenUrl(dev: Boolean): String {
        return nativeGetAdvisorTokenUrl(dev, nativePtr)
    }

    private external fun nativeGetAdvisorTokenUrl(dev: Boolean, nativePtr: Long): String

    fun getAdvisorBaseUrl(dev: Boolean): String {
        return nativeGetAdvisorBaseUrl(dev, nativePtr)
    }

    private external fun nativeGetAdvisorBaseUrl(dev: Boolean, nativePtr: Long): String

    fun getAdvisorToolsUrl(dev: Boolean): String {
        return nativeGetAdvisorToolsUrl(dev, nativePtr)
    }

    private external fun nativeGetAdvisorToolsUrl(dev: Boolean, nativePtr: Long): String

    fun getIconUrl(): String {
        return nativeGetIconUrl()
    }

    private external fun nativeGetIconUrl(): String

    fun getLocalDatasetId(): String {
        return nativeGetLocalDatasetId()
    }

    private external fun nativeGetLocalDatasetId(): String

    fun getTokenUrl(dev: Boolean): String {
        return nativeGetTokenUrl(dev, nativePtr)
    }

    private external fun nativeGetTokenUrl(dev: Boolean, nativePtr: Long): String
}