package ai.passio.passiosdk.core.utils

import java.io.IOException
import java.io.InputStream
import java.nio.ByteBuffer
import kotlin.experimental.and
import kotlin.math.min

internal class ByteBufferBackedInputStream(private val buffer: ByteBuffer) : InputStream() {

    @Throws(IOException::class)
    override fun read(): Int {
        if (!buffer.hasRemaining()) {
            return -1
        }
        return (buffer.get() and 0xFF.toByte()).toInt()
    }

    override fun read(b: ByteArray, off: Int, len: Int): Int {
        if (!buffer.hasRemaining()) {
            return -1
        }

        val length = min(len, buffer.remaining())
        buffer.get(b, off, length)
        return length
    }
}