package ai.passio.passiosdk.passiofood.mlkit

import java.lang.reflect.Method

internal object ReflectionCache {

    private var barcodeClass_: Class<out Any>? = null

    fun barcodeClass(): Class<out Any> {
        if (barcodeClass_ == null) {
            barcodeClass_ = try {
                Class.forName("com.google.mlkit.vision.barcode.Barcode")
            } catch (e: ClassNotFoundException) {
                try {
                    Class.forName("com.google.mlkit.vision.barcode.common.Barcode")
                } catch (e: Exception) {
                    throw e
                }
            }
        }
        return barcodeClass_!!
    }

    private var barcodeValue_: Method? = null

    fun barcodeValue(clazz: Class<out Any>): Method {
        if (barcodeValue_ == null) {
            barcodeValue_ = try {
                clazz.getMethod("getDisplayValue")
            } catch (e: Exception) {
                throw e
            }
        }
        return barcodeValue_!!
    }

    private var barcodeBB_: Method? = null

    fun barcodeBoundingBox(clazz: Class<out Any>): Method {
        if (barcodeBB_ == null) {
            barcodeBB_ = try {
                clazz.getMethod("getBoundingBox")
            } catch (e: Exception) {
                throw e
            }
        }
        return barcodeBB_!!
    }
}