package ai.passio.passiosdk.passiofood.upc

import ai.passio.passiosdk.core.utils.asIntList
import ai.passio.passiosdk.core.utils.asStringList
import ai.passio.passiosdk.core.utils.getDoubleOptional
import ai.passio.passiosdk.core.utils.getJSONArrayOptional
import ai.passio.passiosdk.core.utils.getListOptional
import ai.passio.passiosdk.core.utils.getLongOptional
import ai.passio.passiosdk.core.utils.getObjectOptional
import ai.passio.passiosdk.core.utils.getStringOptional
import org.json.JSONObject

internal class ResponseIngredient(json: String) : JSONObject(json) {
    val id: String? by lazy { this.optString("id") }
    val name: String? by lazy { this.optString("name") }
    val iconId: String? by lazy { this.getStringOptional("iconId") }
    val timestamp: String? by lazy { this.getStringOptional("timestamp") }
    val nutrients: List<ResponseNutrient>? by lazy {
        getListOptional(this, "nutrients", ::ResponseNutrient)
    }
    val portions: List<ResponsePortions>? by lazy {
        getListOptional(this, "portions", ::ResponsePortions)
    }
    val branded: ResponseBranded? by lazy {
        getObjectOptional(this, "branded", ::ResponseBranded)
    }
    val origin: List<ResponseOrigin>? by lazy {
        getListOptional(this, "origin", ::ResponseOrigin)
    }
    val licenseCopy: String? by lazy { this.getStringOptional("licenseCopy") }

    val tags: List<String>? by lazy {
        this.getJSONArrayOptional("tags")?.asStringList()
    }

    val refCode: String? by lazy { this.getStringOptional("refCode") }

    val concerns: List<Int>? by lazy {
         this.getJSONArrayOptional("concerns")?.asIntList()
    }
}

internal class ResponseNutrient(json: String) : JSONObject(json) {
    val id: Long? by lazy { this.getLongOptional("id") }
    val amount: Double? by lazy { this.getDoubleOptional("amount") }
    val nutrient: ResponseInternalNutrient? by lazy {
        getObjectOptional(this, "nutrient", ::ResponseInternalNutrient)
    }
}

internal class ResponseInternalNutrient(json: String) : JSONObject(json) {
    val name: String? by lazy { this.getStringOptional("name") }
    val unit: String? by lazy { this.getStringOptional("unit") }
    val shortName: String? by lazy { this.getStringOptional("shortName") }
    val origin: List<ResponseOrigin>? by lazy {
        getListOptional(this, "origin", ::ResponseOrigin)
    }
}

internal class ResponseOrigin(json: String) : JSONObject(json) {
    val source: String by lazy { this.getString("source") }
    val id: String by lazy { this.getString("id") }
    val dataType: String? by lazy { this.getStringOptional("dataType") }
    val timestamp: String? by lazy { this.getStringOptional("timestamp") }
}

internal class ResponsePortions(json: String) : JSONObject(json) {
    val weight: ResponseWeight? by lazy {
        getObjectOptional(this, "weight", ::ResponseWeight)
    }
    val name: String? by lazy { this.getStringOptional("name") }
    val quantity: Double? by lazy { this.getDoubleOptional("quantity") }
    val suggestedQuantity: List<Double>? by lazy {
        val quantityList = mutableListOf<Double>()
        val jArray = this.getJSONArrayOptional("suggestedQuantity") ?: return@lazy null
        for (i in 0 until jArray.length()) {
            quantityList.add(jArray.getDouble(i))
        }
        quantityList
    }
}

internal class ResponseWeight(json: String) : JSONObject(json) {
    val unit: String? by lazy { this.getStringOptional("unit") }
    val value: Double? by lazy { this.getDoubleOptional("value") }
}

internal class ResponseBranded(json: String) : JSONObject(json) {
    val owner: String? by lazy { this.getStringOptional("owner") }
    val productCode: String? by lazy { this.getStringOptional("productCode") }
    val ingredients: String? by lazy { this.getStringOptional("ingredients") }
    val country: String? by lazy { this.getStringOptional("country") }
}