package ai.passio.passiosdk.passiofood.voting

import ai.passio.passiosdk.passiofood.ClassificationCandidate
import ai.passio.passiosdk.passiofood.ObjectDetectionCandidate
import ai.passio.passiosdk.passiofood.PassioSDK
import ai.passio.passiosdk.passiofood.PassioSDKDebug
import ai.passio.passiosdk.passiofood.VotedCandidate

private const val CONFIDENCE_THRESHOLD = 0.35

internal class HNNKNNVotingLayer : VotingLayer {

    override fun vote(
        objectDetectionCandidate: ObjectDetectionCandidate,
        hnnCandidate: ClassificationCandidate,
        knnCandidate: ClassificationCandidate
    ): VotedCandidate? {

        if (hnnCandidate.confidence < CONFIDENCE_THRESHOLD || hnnCandidate.passioID == PassioSDK.BKG_PASSIO_ID) {
            return null
        }

        if (hnnCandidate.passioID == knnCandidate.passioID) return VotedCandidate(
            hnnCandidate.passioID,
            hnnCandidate.confidence,
            objectDetectionCandidate.boundingBox
        )

        val isSibling = (PassioSDK.instance as PassioSDKDebug).lookupAllSiblingsFor(hnnCandidate.passioID)
            ?.contains(knnCandidate.passioID) ?: false
        return if (isSibling) {
            VotedCandidate(
                hnnCandidate.passioID,
                hnnCandidate.confidence,
                objectDetectionCandidate.boundingBox
            )
        } else {
            null
        }
    }
}