package ai.passio.passiosdk.core.report

import ai.passio.passiosdk.core.network.NetworkTask
import java.io.IOException
import java.net.URL
import javax.net.ssl.HttpsURLConnection

internal class PostJsonNetworkTask(
    urlString: String,
    headers: Map<String, String>,
    private val payloadJson: String
) : NetworkTask<Boolean>(urlString, headers) {
    override fun executeTask(): Boolean {
        val url = URL(url)
        var connection: HttpsURLConnection? = null
        return try {
            connection = (url.openConnection() as? HttpsURLConnection)
            connection?.run {
                readTimeout = 3000
                connectTimeout = 3000
                requestMethod = "POST"
                headers.forEach { (k, v) ->
                    setRequestProperty(k, v)
                }
                if (enableLog) {
                    logRequest(this)
                }
                doOutput = true

                val input = payloadJson.toByteArray()
                outputStream.write(input)
                if (enableLog) {
                    logResponse(this)
                }
                checkResponse(this)

                true
            } ?: throw IOException("Could not open http connection")
        } finally {
            // Close Stream and disconnect HTTPS connection.
            try {
                connection?.outputStream?.close()
                connection?.disconnect()
            } catch (e: Exception) {
                // NO-OP
            }
        }
    }
}