package ai.passio.passiosdk.passiofood

/**
 * Object needed to configure a detection session through the [PassioSDK.startFoodDetection] method.
 */
data class FoodDetectionConfiguration(
    /**
     * Defines how often the recognition engine will take a camera frame from processing.
     */
    var framesPerSecond: PassioSDK.FramesPerSecond = PassioSDK.FramesPerSecond.TWO,
    /**
     * If enabled, the recognition engine will run food object detection and classification.
     */
    var detectVisual: Boolean = true,
    /**
     * If enabled, the recognition engine will scan barcodes. After a barcode is detected, calling
     * [PassioSDK.fetchPassioIDAttributesForBarcode] will return its nutritional information if
     * available.
     */
    var detectBarcodes: Boolean = false,
)