package ai.passio.passiosdk.passiofood.data.model

import ai.passio.passiosdk.passiofood.data.measurement.Grams
import ai.passio.passiosdk.passiofood.data.measurement.Unit
import ai.passio.passiosdk.passiofood.data.measurement.UnitEnergy
import ai.passio.passiosdk.passiofood.data.measurement.UnitMass
import ai.passio.passiosdk.passiofood.upc.ResponseNutrient
import kotlin.reflect.KClass
import kotlin.reflect.KMutableProperty0

data class PassioNutrients internal constructor(val weight: UnitMass) {

    var referenceWeight = UnitMass(Grams, 100.0)

    private var refAlcohol: UnitMass? = null
    private var refCalcium: UnitMass? = null
    private var refCalories: UnitEnergy? = null
    private var refCarbs: UnitMass? = null
    private var refCholesterol: UnitMass? = null
    private var refChromium: UnitMass? = null
    private var refFibers: UnitMass? = null
    private var refFolicAcid: UnitMass? = null
    private var refFat: UnitMass? = null
    private var refIron: UnitMass? = null
    private var refIodine: UnitMass? = null
    private var refMagnesium: UnitMass? = null
    private var refMonounsaturatedFat: UnitMass? = null
    private var refPhosphorus: UnitMass? = null
    private var refPolyunsaturatedFat: UnitMass? = null
    private var refPotassium: UnitMass? = null
    private var refProteins: UnitMass? = null
    private var refSatFat: UnitMass? = null
    private var refSelenium: UnitMass? = null
    private var refSodium: UnitMass? = null
    private var refSugars: UnitMass? = null
    private var refSugarsAdded: UnitMass? = null
    private var refSugarAlcohol: UnitMass? = null
    private var refTransFat: UnitMass? = null
    private var refVitaminA: Double? = null
    private var refVitaminARAE: UnitMass? = null
    private var refVitaminB6: UnitMass? = null
    private var refVitaminB12: UnitMass? = null
    private var refVitaminB12Added: UnitMass? = null
    private var refVitaminC: UnitMass? = null
    private var refVitaminD: UnitMass? = null
    private var refVitaminE: UnitMass? = null
    private var refVitaminEAdded: UnitMass? = null
    private var refVitaminKPhylloquinone: UnitMass? = null
    private var refVitaminKMenaquinone4: UnitMass? = null
    private var refVitaminKDihydrophylloquinone: UnitMass? = null
    private var refZinc: UnitMass? = null

    fun fat(): UnitMass? = scaleValueByAmount(::refFat)
    fun calories(): UnitEnergy? = scaleValueByAmount(refCalories)
    fun protein(): UnitMass? = scaleValueByAmount(::refProteins)
    fun carbs(): UnitMass? = scaleValueByAmount(::refCarbs)
    fun satFat(): UnitMass? = scaleValueByAmount(::refSatFat)
    fun monounsaturatedFat(): UnitMass? = scaleValueByAmount(::refMonounsaturatedFat)
    fun polyunsaturatedFat(): UnitMass? = scaleValueByAmount(::refPolyunsaturatedFat)
    fun cholesterol(): UnitMass? = scaleValueByAmount(::refCholesterol)
    fun sodium(): UnitMass? = scaleValueByAmount(::refSodium)
    fun fibers(): UnitMass? = scaleValueByAmount(::refFibers)
    fun transFat(): UnitMass? = scaleValueByAmount(::refTransFat)
    fun sugars(): UnitMass? = scaleValueByAmount(::refSugars)
    fun sugarsAdded(): UnitMass? = scaleValueByAmount(::refSugarsAdded)
    fun alcohol(): UnitMass? = scaleValueByAmount(::refAlcohol)
    fun iron(): UnitMass? = scaleValueByAmount(::refIron)
    fun vitaminC(): UnitMass? = scaleValueByAmount(::refVitaminC)
    fun vitaminA(): Double? = scaleValueByAmount(refVitaminA)
    fun vitaminD(): UnitMass? = scaleValueByAmount(::refVitaminD)
    fun vitaminB6(): UnitMass? = scaleValueByAmount(::refVitaminB6)
    fun vitaminB12(): UnitMass? = scaleValueByAmount(::refVitaminB12)
    fun calcium(): UnitMass? = scaleValueByAmount(::refCalcium)
    fun potassium(): UnitMass? = scaleValueByAmount(::refPotassium)
    fun magnesium(): UnitMass? = scaleValueByAmount(::refMagnesium)
    fun phosphorus(): UnitMass? = scaleValueByAmount(::refPhosphorus)
    fun sugarAlcohol(): UnitMass? = scaleValueByAmount(::refSugarAlcohol)
    fun vitaminB12Added(): UnitMass? = scaleValueByAmount(::refVitaminB12Added)
    fun vitaminE(): UnitMass? = scaleValueByAmount(::refVitaminE)
    fun vitaminEAdded(): UnitMass? = scaleValueByAmount(::refVitaminEAdded)
    fun iodine(): UnitMass? = scaleValueByAmount(::refIodine)
    fun zinc(): UnitMass? = scaleValueByAmount(::refZinc)
    fun selenium(): UnitMass? = scaleValueByAmount(::refSelenium)
    fun folicAcid(): UnitMass? = scaleValueByAmount(::refFolicAcid)
    fun vitaminKPhylloquinone(): UnitMass? = scaleValueByAmount(::refVitaminKPhylloquinone)
    fun chromium(): UnitMass? = scaleValueByAmount(::refChromium)
    fun vitaminKMenaquinone4(): UnitMass? = scaleValueByAmount(::refVitaminKMenaquinone4)
    fun vitaminKDihydrophylloquinone(): UnitMass? =
        scaleValueByAmount(::refVitaminKDihydrophylloquinone)

    fun vitaminARAE(): UnitMass? = scaleValueByAmount(::refVitaminARAE)

    private fun scaleValueByAmount(field: KMutableProperty0<UnitMass?>): UnitMass? {
        if (field.get() == null) {
            return null
        }

        return field.get()!! * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    private fun scaleValueByAmount(unitEnergy: UnitEnergy?): UnitEnergy? {
        if (unitEnergy == null) {
            return null
        }

        return unitEnergy * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    private fun scaleValueByAmount(value: Double?): Double? {
        if (value == null) return null

        return value * (weight.gramsValue() / referenceWeight.gramsValue())
    }

    constructor(
        referenceNutrients: PassioNutrients,
        weight: UnitMass = UnitMass(Grams, 100.0)
    ) : this(weight) {
        refFat = referenceNutrients.refFat
        refSatFat = referenceNutrients.refSatFat
        refMonounsaturatedFat = referenceNutrients.refMonounsaturatedFat
        refPolyunsaturatedFat = referenceNutrients.refPolyunsaturatedFat
        refProteins = referenceNutrients.refProteins
        refCarbs = referenceNutrients.refCarbs
        refCalories = referenceNutrients.refCalories
        refCholesterol = referenceNutrients.refCholesterol
        refSodium = referenceNutrients.refSodium
        refFibers = referenceNutrients.refFibers
        refTransFat = referenceNutrients.refTransFat
        refSugars = referenceNutrients.refSugars
        refSugarsAdded = referenceNutrients.refSugarsAdded
        refAlcohol = referenceNutrients.refAlcohol
        refIron = referenceNutrients.refIron
        refVitaminC = referenceNutrients.refVitaminC
        refVitaminD = referenceNutrients.refVitaminD
        refVitaminB6 = referenceNutrients.refVitaminB6
        refVitaminB12 = referenceNutrients.refVitaminB12
        refVitaminB12Added = referenceNutrients.refVitaminB12Added
        refVitaminE = referenceNutrients.refVitaminE
        refVitaminEAdded = referenceNutrients.refVitaminEAdded
        refIodine = referenceNutrients.refIodine
        refCalcium = referenceNutrients.refCalcium
        refPotassium = referenceNutrients.refPotassium
        refMagnesium = referenceNutrients.refMagnesium
        refPhosphorus = referenceNutrients.refPhosphorus
        refSugarAlcohol = referenceNutrients.refSugarAlcohol
        refVitaminA = referenceNutrients.refVitaminA
        refZinc = referenceNutrients.refZinc
        refSelenium = referenceNutrients.refSelenium
        refFolicAcid = referenceNutrients.refFolicAcid
        refVitaminKPhylloquinone = referenceNutrients.refVitaminKPhylloquinone
        refChromium = referenceNutrients.refChromium
        refVitaminKMenaquinone4 = referenceNutrients.refVitaminKMenaquinone4
        refVitaminKDihydrophylloquinone = referenceNutrients.refVitaminKDihydrophylloquinone
        refVitaminARAE = referenceNutrients.refVitaminARAE
    }

    constructor(
        ingredientsData: List<Pair<PassioNutrients, Double>>, weight: UnitMass
    ) : this(weight) {
        refFat = ingredientsData.map { it.first.refFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSatFat = ingredientsData.map { it.first.refSatFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refMonounsaturatedFat =
            ingredientsData.map { it.first.refMonounsaturatedFat?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPolyunsaturatedFat =
            ingredientsData.map { it.first.refPolyunsaturatedFat?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refProteins = ingredientsData.map { it.first.refProteins?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCarbs = ingredientsData.map { it.first.refCarbs?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCholesterol = ingredientsData.map { it.first.refCholesterol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSodium = ingredientsData.map { it.first.refSodium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refFibers = ingredientsData.map { it.first.refFibers?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refTransFat = ingredientsData.map { it.first.refTransFat?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugars = ingredientsData.map { it.first.refSugars?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugarsAdded = ingredientsData.map { it.first.refSugarsAdded?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refAlcohol = ingredientsData.map { it.first.refAlcohol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refIron = ingredientsData.map { it.first.refIron?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminC = ingredientsData.map { it.first.refVitaminC?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminD = ingredientsData.map { it.first.refVitaminD?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB6 = ingredientsData.map { it.first.refVitaminB6?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB12 = ingredientsData.map { it.first.refVitaminB12?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminB12Added = ingredientsData.map { it.first.refVitaminB12Added?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminE = ingredientsData.map { it.first.refVitaminE?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminEAdded = ingredientsData.map { it.first.refVitaminEAdded?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refIodine = ingredientsData.map { it.first.refIodine?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCalcium = ingredientsData.map { it.first.refCalcium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPotassium = ingredientsData.map { it.first.refPotassium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refMagnesium = ingredientsData.map { it.first.refMagnesium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refPhosphorus = ingredientsData.map { it.first.refPhosphorus?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSugarAlcohol = ingredientsData.map { it.first.refSugarAlcohol?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refCalories = ingredientsData.map { it.first.refCalories?.times(it.second) }
            .reduce { acc, unitEnergy -> acc?.plus(unitEnergy) ?: unitEnergy }
        refVitaminA = ingredientsData.map { it.first.refVitaminA?.times(it.second) }
            .reduce { acc, value -> acc?.plus(value ?: 0.0) ?: value }
        refZinc = ingredientsData.map { it.first.refZinc?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refSelenium = ingredientsData.map { it.first.refSelenium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refFolicAcid = ingredientsData.map { it.first.refFolicAcid?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKPhylloquinone =
            ingredientsData.map { it.first.refVitaminKPhylloquinone?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refChromium = ingredientsData.map { it.first.refChromium?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKMenaquinone4 =
            ingredientsData.map { it.first.refVitaminKMenaquinone4?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminKDihydrophylloquinone =
            ingredientsData.map { it.first.refVitaminKDihydrophylloquinone?.times(it.second) }
                .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
        refVitaminARAE = ingredientsData.map { it.first.refVitaminARAE?.times(it.second) }
            .reduce { acc, unitMass -> acc?.plus(unitMass) ?: unitMass }
    }

    internal constructor(
        weight: UnitMass = UnitMass(Grams, 100.0),
        responseNutrients: List<ResponseNutrient>,
    ) : this(weight) {
        responseNutrients.forEach { upcNutrient ->
            val upcUnit = upcNutrient.nutrient?.unit ?: "g"
            val unit = Unit.unitFromString(upcUnit) ?: return@forEach
            val amount = upcNutrient.amount ?: 0.0
            var assigned = true

            when (upcNutrient.id) {
                1603211196555 -> refAlcohol = UnitMass(unit, amount)
                1603211196577 -> refCalcium = UnitMass(unit, amount)
                1603211196548 -> refCalories = UnitEnergy(unit, amount)
                1603211196546 -> refCarbs = UnitMass(unit, amount)
                1603211196677 -> refCholesterol = UnitMass(unit, amount)
                1603211196586 -> refChromium = UnitMass(unit, amount)
                1603211196571 -> refFibers = UnitMass(unit, amount)
                1603211196640 -> refFolicAcid = UnitMass(unit, amount)
                1603211196545 -> refFat = UnitMass(unit, amount)
                1603211196579 -> refIron = UnitMass(unit, amount)
                1603211196590 -> refIodine = UnitMass(unit, amount)
                1603211196580 -> refMagnesium = UnitMass(unit, amount)
                1603211196709 -> refMonounsaturatedFat = UnitMass(unit, amount)
                1603211196581 -> refPhosphorus = UnitMass(unit, amount)
                1603211196710 -> refPolyunsaturatedFat = UnitMass(unit, amount)
                1603211196582 -> refPotassium = UnitMass(unit, amount)
                1603211196544 -> refProteins = UnitMass(unit, amount)
                1603211196679 -> refSatFat = UnitMass(unit, amount)
                1603211196593 -> refSelenium = UnitMass(unit, amount)
                1603211196583 -> refSodium = UnitMass(unit, amount)
                1603211196751 -> refSugars = UnitMass(unit, amount)
                1603211196674 -> refSugarsAdded = UnitMass(unit, amount)
                1603211196576 -> refSugarAlcohol = UnitMass(unit, amount)
                1603211196678 -> refTransFat = UnitMass(unit, amount)
                1603211196594 -> refVitaminA = upcNutrient.amount
                1603211196596 -> refVitaminARAE = UnitMass(unit, amount)
                1603211196631 -> refVitaminB6 = UnitMass(unit, amount)
                1603211196634 -> refVitaminB12 = UnitMass(unit, amount)
                1603211196676 -> refVitaminB12Added = UnitMass(unit, amount)
                1603211196626 -> refVitaminC = UnitMass(unit, amount)
                1603211196604 -> refVitaminD = UnitMass(unit, amount)
                1603211196599 -> refVitaminE = UnitMass(unit, amount)
                1603211196675 -> refVitaminEAdded = UnitMass(unit, amount)
                1603211196639 -> refVitaminKPhylloquinone = UnitMass(unit, amount)
                1603211196637 -> refVitaminKMenaquinone4 = UnitMass(unit, amount)
                1603211196638 -> refVitaminKDihydrophylloquinone = UnitMass(unit, amount)
                1603211196585 -> refZinc = UnitMass(unit, amount)
                else -> assigned = false
            }

            if (!assigned) {
                when(upcNutrient.nutrient?.shortName) {
                    "alcohol" -> refAlcohol = UnitMass(unit, amount)
                    "calcium" -> refCalcium = UnitMass(unit, amount)
                    "calories" -> refCalories = UnitEnergy(unit, amount)
                    "carbs" -> refCarbs = UnitMass(unit, amount)
                    "cholesterol" -> refCholesterol = UnitMass(unit, amount)
                    "chromium" -> refChromium = UnitMass(unit, amount)
                    "fibers" -> refFibers = UnitMass(unit, amount)
                    "folicAcid" -> refFolicAcid = UnitMass(unit, amount)
                    "fat" -> refFat = UnitMass(unit, amount)
                    "iron" -> refIron = UnitMass(unit, amount)
                    "iodine" -> refIodine = UnitMass(unit, amount)
                    "magnesium" -> refMagnesium = UnitMass(unit, amount)
                    "monounsaturatedFat" -> refMonounsaturatedFat = UnitMass(unit, amount)
                    "phosphorus" -> refPhosphorus = UnitMass(unit, amount)
                    "polyunsaturatedFat" -> refPolyunsaturatedFat = UnitMass(unit, amount)
                    "potassium" -> refPotassium = UnitMass(unit, amount)
                    "protein" -> refProteins = UnitMass(unit, amount)
                    "satFat" -> refSatFat = UnitMass(unit, amount)
                    "selenium" -> refSelenium = UnitMass(unit, amount)
                    "sodium" -> refSodium = UnitMass(unit, amount)
                    "sugarTotal" -> refSugars = UnitMass(unit, amount)
                    "sugarAdded" -> refSugarsAdded = UnitMass(unit, amount)
                    "sugarAlcohol" -> refSugarAlcohol = UnitMass(unit, amount)
                    "transFat" -> refTransFat = UnitMass(unit, amount)
                    "vitaminA" -> refVitaminA = upcNutrient.amount
                    "vitaminARAE" -> refVitaminARAE = UnitMass(unit, amount)
                    "vitaminB6" -> refVitaminB6 = UnitMass(unit, amount)
                    "vitaminB12" -> refVitaminB12 = UnitMass(unit, amount)
                    "vitaminB12Added" -> refVitaminB12Added = UnitMass(unit, amount)
                    "vitaminC" -> refVitaminC = UnitMass(unit, amount)
                    "vitaminD" -> refVitaminD = UnitMass(unit, amount)
                    "vitaminE" -> refVitaminE = UnitMass(unit, amount)
                    "vitaminEAdded" -> refVitaminEAdded = UnitMass(unit, amount)
                    "vitaminKPhylloquinone" -> refVitaminKPhylloquinone = UnitMass(unit, amount)
                    "vitaminKMenaquinone4" -> refVitaminKMenaquinone4 = UnitMass(unit, amount)
                    "vitaminKDihydrophylloquinone" -> refVitaminKDihydrophylloquinone = UnitMass(unit, amount)
                    "zinc" -> refZinc = UnitMass(unit, amount)

                }
            }
        }
    }

    constructor(
        weight: UnitMass = UnitMass(value = 100.0),
        fat: UnitMass? = null,
        satFat: UnitMass? = null,
        monounsaturatedFat: UnitMass? = null,
        polyunsaturatedFat: UnitMass? = null,
        proteins: UnitMass? = null,
        carbs: UnitMass? = null,
        calories: UnitEnergy? = null,
        cholesterol: UnitMass? = null,
        sodium: UnitMass? = null,
        fibers: UnitMass? = null,
        transFat: UnitMass? = null,
        sugars: UnitMass? = null,
        sugarsAdded: UnitMass? = null,
        alcohol: UnitMass? = null,
        iron: UnitMass? = null,
        vitaminC: UnitMass? = null,
        vitaminD: UnitMass? = null,
        vitaminB6: UnitMass? = null,
        vitaminB12: UnitMass? = null,
        vitaminB12Added: UnitMass? = null,
        vitaminE: UnitMass? = null,
        vitaminEAdded: UnitMass? = null,
        iodine: UnitMass? = null,
        calcium: UnitMass? = null,
        potassium: UnitMass? = null,
        magnesium: UnitMass? = null,
        phosphorus: UnitMass? = null,
        sugarAlcohol: UnitMass? = null,
        vitaminA: Double? = null,
        vitaminARAE: UnitMass? = null,
        vitaminKPhylloquinone: UnitMass? = null,
        vitaminKMenaquinone4: UnitMass? = null,
        vitaminKDihydrophylloquinone: UnitMass? = null,
        zinc: UnitMass? = null,
        chromium: UnitMass? = null,
        selenium: UnitMass? = null,
        folicAcid: UnitMass? = null,
    ) : this(UnitMass(Grams, 100.0)) {
        val ratio = 100 / weight.gramsValue()

        refFat = fat?.times(ratio)
        refSatFat = satFat?.times(ratio)
        refMonounsaturatedFat = monounsaturatedFat?.times(ratio)
        refPolyunsaturatedFat = polyunsaturatedFat?.times(ratio)
        refProteins = proteins?.times(ratio)
        refCarbs = carbs?.times(ratio)
        refCalories = calories?.times(ratio)
        refCholesterol = cholesterol?.times(ratio)
        refSodium = sodium?.times(ratio)
        refFibers = fibers?.times(ratio)
        refTransFat = transFat?.times(ratio)
        refSugars = sugars?.times(ratio)
        refSugarsAdded = sugarsAdded?.times(ratio)
        refAlcohol = alcohol?.times(ratio)
        refIron = iron?.times(ratio)
        refVitaminC = vitaminC?.times(ratio)
        refVitaminD = vitaminD?.times(ratio)
        refVitaminB6 = vitaminB6?.times(ratio)
        refVitaminB12 = vitaminB12?.times(ratio)
        refVitaminB12Added = vitaminB12Added?.times(ratio)
        refVitaminE = vitaminE?.times(ratio)
        refVitaminEAdded = vitaminEAdded?.times(ratio)
        refIodine = iodine?.times(ratio)
        refCalcium = calcium?.times(ratio)
        refPotassium = potassium?.times(ratio)
        refMagnesium = magnesium?.times(ratio)
        refPhosphorus = phosphorus?.times(ratio)
        refSugarAlcohol = sugarAlcohol?.times(ratio)
        refVitaminA = vitaminA?.times(ratio)
        refVitaminARAE = vitaminARAE?.times(ratio)
        refZinc = zinc?.times(ratio)
        refSelenium = selenium?.times(ratio)
        refFolicAcid = folicAcid?.times(ratio)
        refVitaminKPhylloquinone = vitaminKPhylloquinone?.times(ratio)
        refVitaminKMenaquinone4 = vitaminKMenaquinone4?.times(ratio)
        refVitaminKDihydrophylloquinone = vitaminKDihydrophylloquinone?.times(ratio)
        refChromium = chromium?.times(ratio)
    }

    override fun toString(): String {
        val builder = StringBuilder("PassioNutrients(weight=$weight)\n")

        val nutrients = listOf(
            "alcohol" to alcohol(),
            "calcium" to calcium(),
            "calories" to calories(),
            "carbs" to carbs(),
            "cholesterol" to cholesterol(),
            "chromium" to chromium(),
            "fibers" to fibers(),
            "folicAcid" to folicAcid(),
            "fat" to fat(),
            "iron" to iron(),
            "iodine" to iodine(),
            "magnesium" to magnesium(),
            "monounsaturatedFat" to monounsaturatedFat(),
            "phosphorus" to phosphorus(),
            "polyunsaturatedFat" to polyunsaturatedFat(),
            "potassium" to potassium(),
            "protein" to protein(),
            "satFat" to satFat(),
            "selenium" to selenium(),
            "sodium" to sodium(),
            "sugars" to sugars(),
            "sugarsAdded" to sugarsAdded(),
            "sugarAlcohol" to sugarAlcohol(),
            "transFat" to transFat(),
            "vitaminA" to vitaminA(),
            "vitaminARAE" to vitaminARAE(),
            "vitaminB6" to vitaminB6(),
            "vitaminB12" to vitaminB12(),
            "vitaminB12Added" to vitaminB12Added(),
            "vitaminC" to vitaminC(),
            "vitaminD" to vitaminD(),
            "vitaminE" to vitaminE(),
            "vitaminEAdded" to vitaminEAdded(),
            "vitaminKPhylloquinone" to vitaminKPhylloquinone(),
            "vitaminKMenaquinone4" to vitaminKMenaquinone4(),
            "vitaminKDihydrophylloquinone" to vitaminKDihydrophylloquinone(),
            "zinc" to zinc()
        )

        nutrients.forEach { (name, value) ->
            value?.let {
                builder.append("$name=$it\n")
            }
        }

        return builder.toString()
    }
}