package ai.passio.passiosdk.passiofood.data.network

import ai.passio.passiosdk.core.utils.getList
import ai.passio.passiosdk.core.utils.getStringOptional
import ai.passio.passiosdk.passiofood.search.SearchResult
import org.json.JSONObject

internal class ResponseAdvisor(json: String) : JSONObject(json) {
    val action: String by lazy { getString("action") }
    val mealTime: String by lazy { getString("mealTime") }
    val date: String by lazy { getString("date") }
    val items: List<ResponseAdvisorItem> by lazy {
        getList(this, "items", ::ResponseAdvisorItem)
    }
}

internal class ResponseAdvisorItem(json: String) : SearchResult(json) {
    val ingredientName: String by lazy { getString("ingredientName") }
    val portionSize: String by lazy { getString("portionSize") }
    val weightGrams: Double by lazy { getDouble("weightGrams") }
    val mealName: String? by lazy { getStringOptional("mealName") }
    val componentName: String? by lazy { getStringOptional("componentName") }
}