package ai.passio.passiosdk.passiofood.recognition

import ai.passio.passiosdk.core.config.SDKFileType
import ai.passio.passiosdk.core.utils.PassioLog
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_HNN_ENv2
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_SSD_HNN
import ai.passio.passiosdk.passiofood.config.passio_FoodNet_Yolo
import ai.passio.passiosdk.passiofood.file.PassioFoodFileManager
import ai.passio.passiosdk.passiofood.metadata.MetadataManager
import ai.passio.passiosdk.passiofood.tflite.TFLiteHNNKNNDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteObjectDetector
import ai.passio.passiosdk.passiofood.tflite.TFLiteYoloObjectDetector
import android.content.Context
import android.util.Size

internal class PassioAssetModelHolder(
    labelManager: MetadataManager,
    fileManager: PassioFoodFileManager
) : PassioModelHolder(labelManager, fileManager) {

    override fun initializeModel(
        context: Context,
        fileType: SDKFileType,
        version: Int
    ): Boolean {
        when (fileType) {
            passio_FoodNet_SSD_HNN -> {
                val modelName = "${passio_FoodNet_SSD_HNN.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val files = fileManager.getFilesFromAssets(context, listOf(passio_FoodNet_SSD_HNN))
                if (files.isEmpty()) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "Couldn't find file $modelName in assets"
                    )
                    return false
                }
                if (files.size > 1) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "More than one alternative for $modelName"
                    )
                    return false
                }
                val fileName = files[0]

                val inputSize = Size(
                    PassioRecognizer.TF_OD_API_INPUT_SIZE,
                    PassioRecognizer.TF_OD_API_INPUT_SIZE
                )

                objectDetector = TFLiteObjectDetector(inputSize).apply {
                    createFromAssetModel(context, fileName)
                }

                return true
            }
            passio_FoodNet_HNN_ENv2 -> {
                val modelName = "${passio_FoodNet_HNN_ENv2.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val files = fileManager.getFilesFromAssets(context, listOf(passio_FoodNet_HNN_ENv2))
                if (files.isEmpty()) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "Couldn't find file $modelName in assets"
                    )
                    return false
                }
                if (files.size > 1) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "More than one alternative for $modelName"
                    )
                    return false
                }
                val fileName = files[0]

                val labels = labelManager.getVisualPassioIDs()
                val inputSize = Size(
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE,
                    PassioRecognizer.TF_HNN_API_INPUT_SIZE
                )

                hnnDetector = assetCatch(modelName) {
                    TFLiteHNNKNNDetector(false, inputSize, labels).apply {
                        createFromAssetModel(context, fileName)
                    }
                }

                return true
            }

            passio_FoodNet_Yolo -> {
                val modelName = "${passio_FoodNet_Yolo.name}.$version.${getExtension()}"
                PassioLog.i(
                    this::class.java.simpleName,
                    "Initializing $modelName"
                )

                val files = fileManager.getFilesFromAssets(context, listOf(passio_FoodNet_Yolo))
                if (files.isEmpty()) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "Couldn't find file $modelName in assets"
                    )
                    return false
                }
                if (files.size > 1) {
                    PassioLog.e(
                        this::class.java.simpleName,
                        "More than one alternative for $modelName"
                    )
                    return false
                }
                val fileName = files[0]

                val inputSize = Size(
                    PassioRecognizer.TF_YOLO_INPUT_SIZE,
                    PassioRecognizer.TF_YOLO_INPUT_SIZE
                )

                objectDetector = TFLiteYoloObjectDetector(inputSize).apply {
                    createFromAssetModel(context, fileName)
                }

                return true
            }

            else -> throw  IllegalArgumentException("No known file type: ${fileType.name}")
        }
    }

    override fun getExtension(): String = "tflite"
}
