package ai.passio.passiosdk.passiofood.utils

internal object DIIHelper {

    val shortNames = listOf(
        "calories",
        "alcohol",
        "carbs",
        "cholesterol",
        "fat",
        "fiber",
        "iron",
        "magnesium",
        "monounsaturatedFat",
        "satFat",
        "transFat",
        "protein",
        "polyunsaturatedFat",
        "vitaminB12",
        "vitaminB6",
        "vitaminD",
        "vitaminC",
        "vitaminE",
    )

    val longNames = listOf(
        "Carotene, beta",
        "Caffeine",
        "Folic acid",
        "Niacin",
        "Riboflavin",
        "Selenium, Se",
        "Thiamin",
        "Zinc, Zn",
        "Isoflavones",
        "Anthocyanidins",
        "Flavones, total",
        "Flavonols, total",
        "Flavans, total",
        "Flavanones, total",
        "18:3 n-3 c,c,c (ALA)",
        "20:5 n-3 (EPA)",
        "20:3 n-3",
        "22:6 n-3 (DHA)",
        "20:4 n-3",
        "22:5 n-3 (DPA)",
        "18:2 n-6 c,c",
        "20:4 n-6",
        "18:3 n-6 c,c,c",
        "20:2 n-6 c,c",
        "20:3 n-6",
        "Vitamin A, RAE",
    )

    val inflammationScores = mapOf(
        "calories" to 0.18,
        "alcohol" to -0.278,
        "carbs" to 0.097,
        "cholesterol" to 0.11,
        "fat" to 0.298,
        "fiber" to -0.663,
        "iron" to 0.032,
        "magnesium" to -0.484,
        "monounsaturatedFat" to -0.009,
        "satFat" to 0.373,
        "transFat" to 0.229,
        "protein" to 0.021,
        "polyunsaturatedFat" to -0.337,
        "vitaminB12" to 0.106,
        "vitaminB6" to -0.365,
        "vitaminD" to -0.446,
        "vitaminC" to -0.424,
        "vitaminE" to -0.419,
        "Carotene, beta" to -0.584,
        "Caffeine" to -0.11,
        "Folic acid" to -0.19,
        "Niacin" to -0.246,
        "Riboflavin" to -0.068,
        "Selenium, Se" to -0.191,
        "Thiamin" to -0.098,
        "Zinc, Zn" to -0.313,
        "Isoflavones" to -0.593,
        "Anthocyanidins" to -0.131,
        "Flavones, total" to -0.616,
        "Flavonols, total" to -0.467,
        "Flavans, total" to -0.415,
        "Flavanones, total" to -0.25,
        "18:3 n-3 c,c,c (ALA)" to -0.436,
        "20:5 n-3 (EPA)" to -0.436,
        "20:3 n-3" to -0.436,
        "22:6 n-3 (DHA)" to -0.436,
        "20:4 n-3" to -0.436,
        "22:5 n-3 (DPA)" to -0.436,
        "18:2 n-6 c,c" to -0.159,
        "20:4 n-6" to -0.159,
        "18:3 n-6 c,c,c" to -0.159,
        "20:2 n-6 c,c" to -0.159,
        "20:3 n-6" to -0.159,
        "Vitamin A, RAE" to -0.401,
    )
}