/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.app.master;

import ai.platon.pulsar.crawl.CrawlLoops;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.h2.tools.Server;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@ImportResource(value={"classpath:pulsar-beans/app-context.xml"})
@ComponentScan(value={"ai.platon.pulsar.rest.api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/pulsar/app/master/PulsarMaster;", "", "crawlLoops", "Lai/platon/pulsar/crawl/CrawlLoops;", "(Lai/platon/pulsar/crawl/CrawlLoops;)V", "getCrawlLoops", "()Lai/platon/pulsar/crawl/CrawlLoops;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "h2Server", "Lorg/h2/tools/Server;", "h2WebServer", "pulsar-master"})
public class PulsarMaster {
    @NotNull
    private final CrawlLoops crawlLoops;
    private final Logger logger;

    public PulsarMaster(@NotNull CrawlLoops crawlLoops) {
        Intrinsics.checkNotNullParameter((Object)crawlLoops, (String)"crawlLoops");
        this.crawlLoops = crawlLoops;
        this.logger = LoggerFactory.getLogger(PulsarMaster.class);
    }

    @NotNull
    public CrawlLoops getCrawlLoops() {
        return this.crawlLoops;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @NotNull
    public Server h2Server() throws SQLException {
        Server server = Server.createTcpServer((String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"createTcpServer()");
        return server;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @NotNull
    public Server h2WebServer() throws SQLException {
        String[] stringArray = new String[]{"-webAllowOthers"};
        Server server = Server.createWebServer((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"createWebServer(\"-webAllowOthers\")");
        return server;
    }
}

