/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import java.util.Random;
import javax.validation.constraints.NotNull;

public class SleepScheduler {
    private final Random random;
    private final long from;
    private final long to;

    public SleepScheduler(long sleepTime) {
        this(sleepTime, sleepTime, null);
    }

    public SleepScheduler(long from, long to) {
        this(from, to, new Random(System.currentTimeMillis() * 13L));
    }

    private SleepScheduler(long from, long to, @NotNull Random random) {
        this.from = from;
        this.to = to;
        this.random = random;
    }

    public void sleep() throws InterruptedException {
        if (this.from == this.to) {
            if (this.from != 0L) {
                Thread.sleep(this.from);
            }
        } else {
            Thread.sleep((long)this.random.nextInt((int)(this.to - this.from)) + this.from);
        }
    }
}

