/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.Handler;
import ai.preferred.venom.HandlerRouter;
import ai.preferred.venom.ValidatorRouter;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.validator.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class UrlRouter
implements HandlerRouter,
ValidatorRouter {
    private final Handler defaultHandler;
    private final Map<Pattern, Handler> handlerRules = new LinkedHashMap<Pattern, Handler>();
    private final Map<Pattern, Validator> validatorRules = new LinkedHashMap<Pattern, Validator>();

    public UrlRouter(Handler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public UrlRouter() {
        this.defaultHandler = null;
    }

    public UrlRouter register(Pattern urlPattern, Handler handler) {
        this.handlerRules.put(urlPattern, handler);
        return this;
    }

    public UrlRouter register(Pattern urlPattern, Validator validator) {
        this.validatorRules.put(urlPattern, validator);
        return this;
    }

    public UrlRouter register(Pattern urlPattern, Handler handler, Validator validator) {
        this.register(urlPattern, handler);
        this.register(urlPattern, validator);
        return this;
    }

    @Override
    public Handler getHandler(Request request) {
        for (Map.Entry<Pattern, Handler> rule : this.handlerRules.entrySet()) {
            if (!rule.getKey().matcher(request.getUrl()).matches()) continue;
            return rule.getValue();
        }
        if (this.defaultHandler != null) {
            return this.defaultHandler;
        }
        throw new RuntimeException("Default handler is not set");
    }

    @Override
    public Validator getValidator(Request request) {
        for (Map.Entry<Pattern, Validator> rule : this.validatorRules.entrySet()) {
            if (!rule.getKey().matcher(request.getUrl()).matches()) continue;
            return rule.getValue();
        }
        return Validator.ALWAYS_VALID;
    }
}

