/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom.validator;

import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.validator.Validator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineValidator
implements Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineValidator.class);
    private final List<Validator> validators;

    public PipelineValidator(Validator ... validators) {
        this.validators = new LinkedList<Validator>(Arrays.asList(validators));
    }

    public PipelineValidator(List<Validator> validators) {
        this.validators = new LinkedList<Validator>(validators);
    }

    @Override
    public Validator.Status isValid(Request request, Response response) {
        int i = 0;
        for (Validator v : this.validators) {
            Validator.Status status = v.isValid(request, response);
            if (status != Validator.Status.VALID) {
                LOGGER.warn("Validator {} failed for {}", (Object)v.getClass().getSimpleName(), (Object)request.getUrl());
                return status;
            }
            ++i;
        }
        return Validator.Status.VALID;
    }
}

