/*
 * Decompiled with CFR 0.152.
 */
package ai.preferred.venom;

import ai.preferred.venom.FatalHandlerException;
import ai.preferred.venom.Handler;
import ai.preferred.venom.HandlerRouter;
import ai.preferred.venom.Interruptible;
import ai.preferred.venom.Session;
import ai.preferred.venom.SleepScheduler;
import ai.preferred.venom.ThreadedWorkerManager;
import ai.preferred.venom.WorkerManager;
import ai.preferred.venom.fetcher.AsyncFetcher;
import ai.preferred.venom.fetcher.Callback;
import ai.preferred.venom.fetcher.Fetcher;
import ai.preferred.venom.fetcher.StopCodeException;
import ai.preferred.venom.job.AbstractQueueScheduler;
import ai.preferred.venom.job.Job;
import ai.preferred.venom.job.PriorityQueueScheduler;
import ai.preferred.venom.job.Scheduler;
import ai.preferred.venom.request.CrawlerRequest;
import ai.preferred.venom.request.Request;
import ai.preferred.venom.response.Response;
import ai.preferred.venom.response.VResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crawler
implements Interruptible {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    @NotNull
    private final Thread crawlerThread;
    @NotNull
    private final AtomicBoolean exitWhenDone;
    @NotNull
    private final Fetcher fetcher;
    private final int maxTries;
    private final double propRetainProxy;
    @Nullable
    private final HandlerRouter router;
    @NotNull
    private final AbstractQueueScheduler scheduler;
    @NotNull
    private final Semaphore connections;
    @NotNull
    private final Session session;
    @NotNull
    private final SleepScheduler sleepScheduler;
    @NotNull
    private final ExecutorService threadPool;
    @NotNull
    private final WorkerManager workerManager;
    @NotNull
    private final Map<Job, Future> pendingJobs;
    private final List<FatalHandlerException> handlerExceptions;

    private Crawler(Builder builder) {
        this.crawlerThread = new Thread(this::run, builder.name);
        this.exitWhenDone = new AtomicBoolean(false);
        this.fetcher = builder.fetcher;
        this.maxTries = builder.maxTries;
        this.propRetainProxy = builder.propRetainProxy;
        this.router = builder.router;
        this.scheduler = builder.scheduler;
        this.connections = new Semaphore(builder.maxConnections);
        this.session = builder.session;
        this.sleepScheduler = builder.sleepScheduler;
        this.threadPool = new ForkJoinPool(builder.parallelism, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(builder.name + " " + worker.getPoolIndex());
            return worker;
        }, null, true);
        this.workerManager = builder.workerManager == null ? new ThreadedWorkerManager(this.threadPool) : builder.workerManager;
        this.pendingJobs = new ConcurrentHashMap<Job, Future>();
        this.handlerExceptions = Collections.synchronizedList(new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Crawler buildDefault() {
        return Crawler.builder().build();
    }

    private void sleep(Job job, long lastRequestTime) throws InterruptedException {
        long timeElapsed;
        long timeElapsedMillis;
        long sleepTime = job.getRequest().getSleepScheduler() == null ? this.sleepScheduler.getSleepTime() : (job.getRequest().getSleepScheduler() != null ? job.getRequest().getSleepScheduler().getSleepTime() : 0L);
        if (sleepTime > (timeElapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeElapsed = System.nanoTime() - lastRequestTime))) {
            Thread.sleep(sleepTime - timeElapsedMillis);
        }
    }

    private CrawlerRequest normalizeRequest(Request request) {
        if (request instanceof CrawlerRequest) {
            return (CrawlerRequest)request;
        }
        return new CrawlerRequest(request);
    }

    private CrawlerRequest prepareRequest(Request request, int tryCount) {
        CrawlerRequest crawlerRequest = this.normalizeRequest(request);
        if (request.getProxy() != null && (double)tryCount / (double)this.maxTries > this.propRetainProxy) {
            crawlerRequest.removeProxy();
        }
        return crawlerRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.fetcher.start();
        long lastRequestTime = 0L;
        while (!Thread.currentThread().isInterrupted() && !this.threadPool.isShutdown() && this.handlerExceptions.isEmpty()) {
            try {
                Job job = this.scheduler.poll(5L, TimeUnit.SECONDS);
                if (job == null) {
                    Map<Job, Future> map = this.pendingJobs;
                    synchronized (map) {
                        LOGGER.debug("({}) Checking for exit conditions.", (Object)this.crawlerThread.getName());
                        if (this.scheduler.peek() == null && this.pendingJobs.size() == 0 && this.exitWhenDone.get()) {
                            break;
                        }
                        continue;
                    }
                }
                this.sleep(job, lastRequestTime);
                lastRequestTime = System.nanoTime();
                this.connections.acquire();
                this.threadPool.execute(() -> {
                    LOGGER.debug("Preparing to fetch {}", (Object)job.getRequest().getUrl());
                    CrawlerRequest crawlerRequest = this.prepareRequest(job.getRequest(), job.getTryCount());
                    if (Thread.currentThread().isInterrupted()) {
                        LOGGER.debug("The thread pool is interrupted");
                        return;
                    }
                    Future<Response> responseFuture = this.fetcher.fetch(crawlerRequest, new AsyncCrawlerCallbackProcessor(this, job));
                    Job job2 = job;
                    synchronized (job2) {
                        this.pendingJobs.put(job, responseFuture);
                        job.notifyAll();
                    }
                });
            }
            catch (InterruptedException e) {
                LOGGER.debug("({}) producer thread interrupted.", (Object)this.crawlerThread.getName(), (Object)e);
                break;
            }
        }
        if (!this.handlerExceptions.isEmpty()) {
            try {
                this.interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.debug("({}) will stop producing requests.", (Object)this.crawlerThread.getName());
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public synchronized Crawler start() {
        this.crawlerThread.start();
        LOGGER.info("{} thread started.", (Object)this.crawlerThread.getName());
        return this;
    }

    public synchronized Crawler startAndClose() throws Exception {
        this.start();
        this.close();
        return this;
    }

    @Override
    public void interruptAndClose() throws Exception {
        this.interrupt();
        try {
            this.crawlerThread.join();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("The joining has been interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void interrupt() throws Exception {
        this.exitWhenDone.set(true);
        this.crawlerThread.interrupt();
        this.threadPool.shutdownNow();
        Exception cachedException = null;
        for (Interruptible interruptible : new Interruptible[]{this.workerManager, this.fetcher}) {
            try {
                interruptible.interruptAndClose();
            }
            catch (Exception e) {
                if (cachedException != null) {
                    cachedException.addSuppressed(e);
                    continue;
                }
                cachedException = e;
            }
        }
        if (cachedException != null) {
            throw cachedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.exitWhenDone.compareAndSet(false, true)) {
            LOGGER.debug("Initialising \"{}\" shutdown, waiting for threads to join...", (Object)this.crawlerThread.getName());
            try {
                this.crawlerThread.join();
                LOGGER.debug("{} producer thread joined.", (Object)this.crawlerThread.getName());
            }
            catch (InterruptedException e) {
                LOGGER.warn("The producer thread joining has been interrupted", (Throwable)e);
                this.threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.threadPool.shutdown();
            try {
                this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("The thread pool joining has been interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            Exception cachedException = null;
            for (AutoCloseable closeable : new AutoCloseable[]{this.workerManager, this.fetcher}) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (cachedException != null) {
                        cachedException.addSuppressed(e);
                        continue;
                    }
                    cachedException = e;
                }
            }
            if (!this.handlerExceptions.isEmpty()) {
                FatalHandlerException mainHandlerException;
                List<FatalHandlerException> list = this.handlerExceptions;
                synchronized (list) {
                    Iterator<FatalHandlerException> iterator = this.handlerExceptions.iterator();
                    mainHandlerException = iterator.next();
                    while (iterator.hasNext()) {
                        mainHandlerException.addSuppressed(iterator.next());
                    }
                    if (cachedException != null) {
                        mainHandlerException.addSuppressed(cachedException);
                    }
                }
                throw mainHandlerException;
            }
            if (cachedException != null) {
                throw cachedException;
            }
        }
    }

    public static final class AsyncCrawlerCallbackProcessor
    implements Callback {
        private final Crawler crawler;
        private final Job job;

        private AsyncCrawlerCallbackProcessor(Crawler crawler, Job job) {
            this.crawler = crawler;
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeJob() {
            Object object = this.job;
            synchronized (object) {
                while (!this.crawler.pendingJobs.containsKey(this.job)) {
                    try {
                        this.job.wait();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Waiting to remove job is interrupted.", (Throwable)e);
                    }
                }
            }
            object = this.crawler.pendingJobs;
            synchronized (object) {
                this.crawler.pendingJobs.remove(this.job);
            }
        }

        @Override
        public void completed(Request request, Response response) {
            this.crawler.connections.release();
            this.crawler.threadPool.execute(() -> {
                try {
                    if (this.job.getHandler() != null) {
                        this.job.getHandler().handle(this.job.getRequest(), new VResponse(response), this.crawler.scheduler, this.crawler.session, this.crawler.workerManager.getWorker());
                    } else if (this.crawler.router != null) {
                        Handler routedHandler = this.crawler.router.getHandler(this.job.getRequest());
                        if (routedHandler != null) {
                            routedHandler.handle(this.job.getRequest(), new VResponse(response), this.crawler.scheduler, this.crawler.session, this.crawler.workerManager.getWorker());
                        }
                    } else {
                        LOGGER.error("No handler to handle request {}.", (Object)this.job.getRequest().getUrl());
                    }
                }
                catch (FatalHandlerException e) {
                    LOGGER.error("Fatal exception occurred in handler, when parsing response ({}), interrupting execution", (Object)this.job.getRequest().getUrl(), (Object)e);
                    this.crawler.handlerExceptions.add(e);
                }
                catch (Exception e) {
                    LOGGER.error("An exception occurred in handler when parsing response: {}", (Object)this.job.getRequest().getUrl(), (Object)e);
                }
                this.removeJob();
            });
        }

        @Override
        public void failed(Request request, Exception ex) {
            this.crawler.connections.release();
            this.crawler.threadPool.execute(() -> {
                if (ex instanceof StopCodeException) {
                    this.removeJob();
                } else {
                    Map map = this.crawler.pendingJobs;
                    synchronized (map) {
                        this.removeJob();
                        if (this.job.getTryCount() < this.crawler.maxTries) {
                            this.job.reQueue();
                        } else {
                            LOGGER.error("Max retries reached for request: {}", (Object)this.job.getRequest().getUrl());
                        }
                    }
                }
            });
        }

        @Override
        public void cancelled(Request request) {
            this.crawler.connections.release();
            this.crawler.threadPool.execute(this::removeJob);
        }
    }

    public static final class Builder {
        private Fetcher fetcher = AsyncFetcher.buildDefault();
        private int maxConnections = Runtime.getRuntime().availableProcessors() * 50;
        private int maxTries = 50;
        private String name = "Crawler";
        private int parallelism = Runtime.getRuntime().availableProcessors();
        private WorkerManager workerManager = null;
        private double propRetainProxy = 0.05;
        private HandlerRouter router = null;
        private AbstractQueueScheduler scheduler = new PriorityQueueScheduler();
        private SleepScheduler sleepScheduler = new SleepScheduler(250L, 2000L);
        private Session session = Session.EMPTY_SESSION;

        private Builder() {
        }

        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        public Builder fetcher(@NotNull Fetcher fetcher) {
            this.fetcher = fetcher;
            return this;
        }

        public Builder parallism(int parallelism) {
            if (parallelism <= 0) {
                LOGGER.warn("Attribute 'numThreads' not within range, defaulting to system default.");
            } else {
                this.parallelism = parallelism;
            }
            return this;
        }

        public Builder workerManager(@NotNull WorkerManager workerManager) {
            this.workerManager = workerManager;
            return this;
        }

        public Builder scheduler(@NotNull AbstractQueueScheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder router(@NotNull HandlerRouter router) {
            this.router = router;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder propRetainProxy(double propRetainProxy) {
            if (propRetainProxy > 1.0 || propRetainProxy < 0.0) {
                LOGGER.warn("Attribute 'propRetainProxy' not within range, defaulting to 0.05.");
            } else {
                this.propRetainProxy = propRetainProxy;
            }
            return this;
        }

        public Builder sleepScheduler(@NotNull SleepScheduler sleepScheduler) {
            this.sleepScheduler = sleepScheduler;
            return this;
        }

        public Builder session(@NotNull Session session) {
            this.session = session;
            return this;
        }

        public Crawler build() {
            return new Crawler(this);
        }
    }
}

